/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar;

import io.github.majusko.pulsar.properties.ConsumerProperties;
import io.github.majusko.pulsar.properties.PulsarProperties;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@EnableConfigurationProperties(value={PulsarProperties.class, ConsumerProperties.class})
public class PulsarAutoConfiguration {
    private final PulsarProperties pulsarProperties;

    public PulsarAutoConfiguration(PulsarProperties pulsarProperties) {
        this.pulsarProperties = pulsarProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarClient pulsarClient() throws PulsarClientException {
        return PulsarClient.builder().serviceUrl(this.pulsarProperties.getServiceUrl()).ioThreads(this.pulsarProperties.getIoThreads().intValue()).listenerThreads(this.pulsarProperties.getListenerThreads().intValue()).enableTcpNoDelay(this.pulsarProperties.isEnableTcpNoDelay()).keepAliveInterval(this.pulsarProperties.getKeepAliveIntervalSec().intValue(), TimeUnit.SECONDS).connectionTimeout(this.pulsarProperties.getConnectionTimeoutSec().intValue(), TimeUnit.SECONDS).operationTimeout(this.pulsarProperties.getOperationTimeoutSec().intValue(), TimeUnit.SECONDS).startingBackoffInterval((long)this.pulsarProperties.getStartingBackoffIntervalMs().intValue(), TimeUnit.MILLISECONDS).maxBackoffInterval((long)this.pulsarProperties.getMaxBackoffIntervalSec().intValue(), TimeUnit.SECONDS).build();
    }
}

