/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar.collector;

import io.github.majusko.pulsar.annotation.PulsarConsumer;
import io.github.majusko.pulsar.collector.ConsumerHolder;
import io.github.majusko.pulsar.utils.SchemaUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConsumerCollector
implements BeanPostProcessor {
    @Value(value="${pulsar.consumerNameDelimiter:}")
    private String consumerNameDelimiter;
    private Map<String, ConsumerHolder> consumers = new ConcurrentHashMap<String, ConsumerHolder>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        this.consumers.putAll(Arrays.stream(beanClass.getDeclaredMethods()).filter($ -> $.isAnnotationPresent(PulsarConsumer.class)).collect(Collectors.toMap(method -> this.getConsumerName(beanClass, (Method)method), method -> new ConsumerHolder(method.getAnnotation(PulsarConsumer.class), (Method)method, bean, SchemaUtils.getParameterType(method)))));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    public Map<String, ConsumerHolder> getConsumers() {
        return this.consumers;
    }

    public Optional<ConsumerHolder> getConsumer(String methodDescriptor) {
        return Optional.ofNullable(this.consumers.get(methodDescriptor));
    }

    public String getConsumerName(Class<?> clazz, Method method) {
        return clazz.getName() + this.consumerNameDelimiter + method.getName() + Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(this.consumerNameDelimiter));
    }
}

