/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.milvus.bulkwriter.BaseCloudImport;
import io.milvus.bulkwriter.request.v2.BulkImportV2Request;
import io.milvus.bulkwriter.request.v2.GetImportProgressV2Request;
import io.milvus.bulkwriter.request.v2.ListImportJobsV2Request;
import io.milvus.bulkwriter.response.RestfulResponse;
import io.milvus.bulkwriter.response.v2.BulkImportV2Response;
import io.milvus.bulkwriter.response.v2.GetImportProgressV2Response;
import io.milvus.bulkwriter.response.v2.ListImportJobsV2Response;
import java.net.MalformedURLException;
import java.util.Map;

public class CloudImportV2
extends BaseCloudImport {
    private static final Gson GSON_INSTANCE = new Gson();

    public static BulkImportV2Response createImportJobs(String url, String apiKey, BulkImportV2Request request) throws MalformedURLException {
        String requestURL = url + "/v2/vectordb/jobs/import/create";
        Map params = (Map)GSON_INSTANCE.fromJson(GSON_INSTANCE.toJson((Object)request), new TypeToken<Map<String, Object>>(){}.getType());
        String body = CloudImportV2.postRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)GSON_INSTANCE.fromJson(body, new TypeToken<RestfulResponse<BulkImportV2Response>>(){}.getType());
        CloudImportV2.handleResponse(requestURL, response);
        return (BulkImportV2Response)response.getData();
    }

    public static GetImportProgressV2Response getImportJobProgress(String url, String apiKey, GetImportProgressV2Request request) throws MalformedURLException {
        String requestURL = url + "/v2/vectordb/jobs/import/getProgress";
        Map params = (Map)GSON_INSTANCE.fromJson(GSON_INSTANCE.toJson((Object)request), new TypeToken<Map<String, Object>>(){}.getType());
        String body = CloudImportV2.postRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)GSON_INSTANCE.fromJson(body, new TypeToken<RestfulResponse<GetImportProgressV2Response>>(){}.getType());
        CloudImportV2.handleResponse(requestURL, response);
        return (GetImportProgressV2Response)response.getData();
    }

    public static ListImportJobsV2Response listImportJobs(String url, String apiKey, ListImportJobsV2Request request) throws MalformedURLException {
        String requestURL = url + "/v2/vectordb/jobs/import/list";
        Map params = (Map)GSON_INSTANCE.fromJson(GSON_INSTANCE.toJson((Object)request), new TypeToken<Map<String, Object>>(){}.getType());
        String body = CloudImportV2.postRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)GSON_INSTANCE.fromJson(body, new TypeToken<RestfulResponse<ListImportJobsV2Response>>(){}.getType());
        CloudImportV2.handleResponse(requestURL, response);
        return (ListImportJobsV2Response)response.getData();
    }
}

