/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.response.v2;

import com.google.common.collect.ImmutableMap;
import io.milvus.bulkwriter.response.ListImportJobsResponse;
import io.milvus.bulkwriter.response.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ListImportJobsV2Response
implements Serializable {
    private static final long serialVersionUID = -8400893490624599225L;
    private Integer count;
    private Integer currentPage;
    private Integer pageSize;
    private List<Record> records;

    public ListImportJobsResponse toListImportJobsResponse() {
        ImmutableMap newOldStateMap = ImmutableMap.of((Object)"Pending", (Object)"ImportPending", (Object)"Importing", (Object)"ImportRunning", (Object)"Completed", (Object)"ImportCompleted", (Object)"Failed", (Object)"ImportFailed", (Object)"Cancel", (Object)"ImportCancel");
        ArrayList<Record> tasks = new ArrayList<Record>();
        for (Record record : this.records) {
            Record task = Record.builder().jobId(record.getJobId()).collectionName(record.getCollectionName()).state((String)newOldStateMap.get(record.getState())).build();
            tasks.add(task);
        }
        ListImportJobsResponse listImportJobsResponse = new ListImportJobsResponse();
        listImportJobsResponse.setCount(this.count);
        listImportJobsResponse.setCurrentPage(this.currentPage);
        listImportJobsResponse.setPageSize(this.pageSize);
        listImportJobsResponse.setTasks(tasks);
        return listImportJobsResponse;
    }

    public static ListImportJobsV2ResponseBuilder builder() {
        return new ListImportJobsV2ResponseBuilder();
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListImportJobsV2Response)) {
            return false;
        }
        ListImportJobsV2Response other = (ListImportJobsV2Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        List<Record> this$records = this.getRecords();
        List<Record> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListImportJobsV2Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        List<Record> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "ListImportJobsV2Response(count=" + this.getCount() + ", currentPage=" + this.getCurrentPage() + ", pageSize=" + this.getPageSize() + ", records=" + this.getRecords() + ")";
    }

    public ListImportJobsV2Response(Integer count, Integer currentPage, Integer pageSize, List<Record> records) {
        this.count = count;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.records = records;
    }

    public ListImportJobsV2Response() {
    }

    public static class ListImportJobsV2ResponseBuilder {
        private Integer count;
        private Integer currentPage;
        private Integer pageSize;
        private List<Record> records;

        ListImportJobsV2ResponseBuilder() {
        }

        public ListImportJobsV2ResponseBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ListImportJobsV2ResponseBuilder currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public ListImportJobsV2ResponseBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListImportJobsV2ResponseBuilder records(List<Record> records) {
            this.records = records;
            return this;
        }

        public ListImportJobsV2Response build() {
            return new ListImportJobsV2Response(this.count, this.currentPage, this.pageSize, this.records);
        }

        public String toString() {
            return "ListImportJobsV2Response.ListImportJobsV2ResponseBuilder(count=" + this.count + ", currentPage=" + this.currentPage + ", pageSize=" + this.pageSize + ", records=" + this.records + ")";
        }
    }
}

