/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.seata.common.util.CollectionUtils;
import io.seata.core.rpc.Disposable;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);
    private static final ShutdownHook SHUTDOWN_HOOK = new ShutdownHook("ShutdownHook");
    private Set<Disposable> disposables = new TreeSet<Disposable>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private static final int DEFAULT_PRIORITY = 10;

    private ShutdownHook(String name) {
        super(name);
    }

    public static ShutdownHook getInstance() {
        return SHUTDOWN_HOOK;
    }

    public void addDisposable(Disposable disposable) {
        this.addDisposable(disposable, 10);
    }

    public void addDisposable(Disposable disposable, int priority) {
        this.disposables.add(new DisposablePriorityWrapper(disposable, priority));
    }

    @Override
    public void run() {
        this.destroyAll();
    }

    public void destroyAll() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll starting");
        }
        if (!this.destroyed.compareAndSet(false, true) && CollectionUtils.isEmpty(this.disposables)) {
            return;
        }
        for (Disposable disposable : this.disposables) {
            disposable.destroy();
        }
    }

    public static void removeRuntimeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    static {
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }

    private static class DisposablePriorityWrapper
    implements Comparable<DisposablePriorityWrapper>,
    Disposable {
        private Disposable disposable;
        private int priority;

        public DisposablePriorityWrapper(Disposable disposable, int priority) {
            this.disposable = disposable;
            this.priority = priority;
        }

        @Override
        public int compareTo(DisposablePriorityWrapper disposablePriorityWrapper) {
            return this.priority - disposablePriorityWrapper.priority;
        }

        public int hashCode() {
            return Objects.hashCode(this.priority);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisposablePriorityWrapper)) {
                return false;
            }
            DisposablePriorityWrapper dpw = (DisposablePriorityWrapper)other;
            return this.priority == dpw.priority && this.disposable.equals(dpw.disposable);
        }

        @Override
        public void destroy() {
            this.disposable.destroy();
        }
    }
}

