/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.domain.impl;

import io.seata.common.util.StringUtils;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.BaseState;
import java.util.List;
import java.util.Map;

public abstract class AbstractTaskState
extends BaseState
implements TaskState {
    private String compensateState;
    private boolean isForCompensation;
    private boolean isForUpdate;
    private List<TaskState.Retry> retry;
    private List<TaskState.ExceptionMatch> catches;
    private List<Object> input;
    private Map<String, Object> output;
    private Map<String, String> status;
    private boolean isPersist = true;

    @Override
    public String getCompensateState() {
        return this.compensateState;
    }

    public void setCompensateState(String compensateState) {
        this.compensateState = compensateState;
        if (StringUtils.isNotBlank(this.compensateState)) {
            this.setForUpdate(true);
        }
    }

    @Override
    public boolean isForCompensation() {
        return this.isForCompensation;
    }

    public void setForCompensation(boolean isForCompensation) {
        this.isForCompensation = isForCompensation;
    }

    @Override
    public boolean isForUpdate() {
        return this.isForUpdate;
    }

    public void setForUpdate(boolean isForUpdate) {
        this.isForUpdate = isForUpdate;
    }

    @Override
    public List<TaskState.Retry> getRetry() {
        return this.retry;
    }

    public void setRetry(List<TaskState.Retry> retry) {
        this.retry = retry;
    }

    @Override
    public List<TaskState.ExceptionMatch> getCatches() {
        return this.catches;
    }

    public void setCatches(List<TaskState.ExceptionMatch> catches) {
        this.catches = catches;
    }

    public List<Object> getInput() {
        return this.input;
    }

    public void setInput(List<Object> input) {
        this.input = input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public boolean isPersist() {
        return this.isPersist;
    }

    public void setPersist(boolean persist) {
        this.isPersist = persist;
    }

    @Override
    public Map<String, String> getStatus() {
        return this.status;
    }

    public void setStatus(Map<String, String> status) {
        this.status = status;
    }

    public static class ExceptionMatchImpl
    implements TaskState.ExceptionMatch {
        List<String> exceptions;
        List<Class<? extends Exception>> exceptionClasses;
        String next;

        @Override
        public List<String> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(List<String> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public List<Class<? extends Exception>> getExceptionClasses() {
            return this.exceptionClasses;
        }

        @Override
        public void setExceptionClasses(List<Class<? extends Exception>> exceptionClasses) {
            this.exceptionClasses = exceptionClasses;
        }

        @Override
        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }

    public static class RetryImpl
    implements TaskState.Retry {
        private List<String> exceptions;
        private List<Class<? extends Exception>> exceptionClasses;
        private double intervalSeconds;
        private int maxAttempts;
        private double backoffRate;

        @Override
        public List<String> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(List<String> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public List<Class<? extends Exception>> getExceptionClasses() {
            return this.exceptionClasses;
        }

        @Override
        public void setExceptionClasses(List<Class<? extends Exception>> exceptionClasses) {
            this.exceptionClasses = exceptionClasses;
        }

        @Override
        public double getIntervalSeconds() {
            return this.intervalSeconds;
        }

        public void setIntervalSeconds(double intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
        }

        @Override
        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public double getBackoffRate() {
            return this.backoffRate;
        }

        public void setBackoffRate(double backoffRate) {
            this.backoffRate = backoffRate;
        }
    }
}

