/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser;

import io.seata.saga.statelang.parser.StateParser;
import io.seata.saga.statelang.parser.impl.ChoiceStateParser;
import io.seata.saga.statelang.parser.impl.CompensateSubStateMachineStateParser;
import io.seata.saga.statelang.parser.impl.CompensationTriggerStateParser;
import io.seata.saga.statelang.parser.impl.FailEndStateParser;
import io.seata.saga.statelang.parser.impl.ServiceTaskStateParser;
import io.seata.saga.statelang.parser.impl.SubStateMachineParser;
import io.seata.saga.statelang.parser.impl.SucceedEndStateParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateParserFactory {
    protected static Map<String, StateParser> stateParserMap = new ConcurrentHashMap<String, StateParser>();

    public static StateParser getStateParser(String stateType) {
        return stateParserMap.get(stateType);
    }

    static {
        stateParserMap.put("ServiceTask", new ServiceTaskStateParser());
        stateParserMap.put("Choice", new ChoiceStateParser());
        stateParserMap.put("CompensationTrigger", new CompensationTriggerStateParser());
        stateParserMap.put("Fail", new FailEndStateParser());
        stateParserMap.put("Succeed", new SucceedEndStateParser());
        stateParserMap.put("SubStateMachine", new SubStateMachineParser());
        stateParserMap.put("CompensateSubMachine", new CompensateSubStateMachineStateParser());
    }
}

