/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.protobuf;

import com.google.protobuf.GeneratedMessageV3;
import io.seata.common.loader.LoadLevel;
import io.seata.core.serializer.Serializer;
import io.seata.serializer.protobuf.ProtobufInnerSerializer;
import io.seata.serializer.protobuf.convertor.PbConvertor;
import io.seata.serializer.protobuf.manager.ProtobufConvertManager;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@LoadLevel(name="PROTOBUF", order=0)
public class ProtobufSerializer
implements Serializer {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;

    @Override
    public <T> byte[] serialize(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchConvertor(t.getClass().getName());
        GeneratedMessageV3 newBody = (GeneratedMessageV3)pbConvertor.convert2Proto(t);
        byte[] body = ProtobufInnerSerializer.serializeContent(newBody);
        String name = newBody.getDescriptorForType().getFullName();
        byte[] nameBytes = name.getBytes(UTF8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + nameBytes.length + body.length);
        byteBuffer.putInt(nameBytes.length);
        byteBuffer.put(nameBytes);
        byteBuffer.put(body);
        byteBuffer.flip();
        byte[] content = new byte[byteBuffer.limit()];
        byteBuffer.get(content);
        return content;
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int clazzNameLength = byteBuffer.getInt();
        byte[] clazzName = new byte[clazzNameLength];
        byteBuffer.get(clazzName);
        byte[] body = new byte[bytes.length - clazzNameLength - 4];
        byteBuffer.get(body);
        String descriptorName = new String(clazzName, UTF8);
        Class protobufClazz = ProtobufConvertManager.getInstance().fetchProtoClass(descriptorName);
        Object protobufObject = ProtobufInnerSerializer.deserializeContent(protobufClazz.getName(), body);
        PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchReversedConvertor(protobufClazz.getName());
        Object newBody = pbConvertor.convert2Model(protobufObject);
        return newBody;
    }
}

