/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.model;

import io.seata.common.exception.ShouldNeverHappenException;

public enum BranchStatus {
    Unknown(0),
    Registered(1),
    PhaseOne_Done(2),
    PhaseOne_Failed(3),
    PhaseOne_Timeout(4),
    PhaseTwo_Committed(5),
    PhaseTwo_CommitFailed_Retryable(6),
    PhaseTwo_CommitFailed_Unretryable(7),
    PhaseTwo_Rollbacked(8),
    PhaseTwo_RollbackFailed_Retryable(9),
    PhaseTwo_RollbackFailed_Unretryable(10);

    private int code;

    private BranchStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static BranchStatus get(byte code) {
        return BranchStatus.get((int)code);
    }

    public static BranchStatus get(int code) {
        BranchStatus value = null;
        try {
            value = BranchStatus.values()[code];
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException("Unknown BranchStatus[" + code + "]");
        }
        return value;
    }
}

