/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.NewInstanceObjectPool;
import io.undertow.util.ObjectPool;
import io.undertow.util.PooledObject;
import io.undertow.util.SimpleObjectPool;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Inflater;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class InflatingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    public static final ConduitWrapper<StreamSourceConduit> WRAPPER = new ConduitWrapper<StreamSourceConduit>(){

        @Override
        public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
            return new InflatingStreamSourceConduit(exchange, factory.create());
        }
    };
    private volatile Inflater inflater;
    private volatile PooledObject<Inflater> activePooledObject;
    private final ObjectPool<Inflater> objectPoolNonWrapping;
    private final ObjectPool<Inflater> objectPoolWrapping;
    private final HttpServerExchange exchange;
    private PooledByteBuffer compressed;
    private PooledByteBuffer uncompressed;
    private boolean nextDone = false;
    private boolean headerDone = false;

    public InflatingStreamSourceConduit(HttpServerExchange exchange, StreamSourceConduit next) {
        this(exchange, next, InflatingStreamSourceConduit.newInstanceInflaterPool(), InflatingStreamSourceConduit.newInstanceWrappingInflaterPool());
    }

    public InflatingStreamSourceConduit(HttpServerExchange exchange, StreamSourceConduit next, ObjectPool<Inflater> inflaterPool) {
        super(next);
        this.exchange = exchange;
        this.objectPoolNonWrapping = inflaterPool;
        this.objectPoolWrapping = null;
    }

    public InflatingStreamSourceConduit(HttpServerExchange exchange, StreamSourceConduit next, ObjectPool<Inflater> inflaterPool, ObjectPool<Inflater> inflaterWrappingPool) {
        super(next);
        this.exchange = exchange;
        this.objectPoolNonWrapping = inflaterPool;
        this.objectPoolWrapping = inflaterWrappingPool;
    }

    public static ObjectPool<Inflater> newInstanceInflaterPool() {
        return new NewInstanceObjectPool<Inflater>(() -> new Inflater(true), Inflater::end);
    }

    public static ObjectPool<Inflater> simpleInflaterPool(int poolSize) {
        return new SimpleObjectPool<Inflater>(poolSize, () -> new Inflater(true), Inflater::reset, Inflater::end);
    }

    public static ObjectPool<Inflater> newInstanceWrappingInflaterPool() {
        return new NewInstanceObjectPool<Inflater>(() -> new Inflater(false), Inflater::end);
    }

    public static ObjectPool<Inflater> simpleWrappingInflaterPool(int poolSize) {
        return new SimpleObjectPool<Inflater>(poolSize, () -> new Inflater(false), Inflater::reset, Inflater::end);
    }

    /*
     * Exception decompiling
     */
    public int read(ByteBuffer dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeInflater(ByteBuffer buf) throws IOException {
        this.activePooledObject = this.isZlibHeaderPresent(buf) ? this.objectPoolWrapping.allocate() : this.objectPoolNonWrapping.allocate();
        this.inflater = this.activePooledObject.getObject();
    }

    protected boolean isZlibHeaderPresent(ByteBuffer buf) throws IOException {
        if (buf.remaining() < 2) {
            throw UndertowMessages.MESSAGES.bufferUnderflow(this.exchange, buf);
        }
        buf.mark();
        char cmf = (char)(buf.get() & 0xFF);
        char flg = (char)(buf.get() & 0xFF);
        buf.reset();
        return cmf == 'x' && (flg == '\u0001' || flg == '^' || flg == '\u009c' || flg == '\u00da');
    }

    protected void readFooter(ByteBuffer buf) throws IOException {
    }

    protected boolean readHeader(ByteBuffer byteBuffer) throws IOException {
        return true;
    }

    protected void dataDeflated(byte[] data, int off, int len) {
    }

    private void done() {
        if (this.compressed != null) {
            this.compressed.close();
        }
        if (this.uncompressed != null) {
            this.uncompressed.close();
        }
        if (this.inflater != null) {
            this.activePooledObject.close();
            this.activePooledObject = null;
            this.inflater = null;
        }
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        try {
            return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            throw e;
        }
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        try {
            return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            throw e;
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public void terminateReads() throws IOException {
        this.done();
        ((StreamSourceConduit)this.next).terminateReads();
    }
}

