/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.kafka.clients.KafkaConsumerRequest;
import brave.kafka.clients.KafkaProducerRequest;
import brave.kafka.clients.KafkaPropagation;
import brave.kafka.clients.TracingConsumer;
import brave.kafka.clients.TracingProducer;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public final class KafkaTracing {
    final MessagingTracing messagingTracing;
    final Tracer tracer;
    final TraceContext.Extractor<KafkaProducerRequest> producerExtractor;
    final TraceContext.Extractor<KafkaConsumerRequest> consumerExtractor;
    final TraceContext.Extractor<Headers> processorExtractor;
    final TraceContext.Injector<KafkaProducerRequest> producerInjector;
    final TraceContext.Injector<KafkaConsumerRequest> consumerInjector;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final Set<String> propagationKeys;
    final String remoteServiceName;

    public static KafkaTracing create(Tracing tracing) {
        return KafkaTracing.newBuilder(tracing).build();
    }

    public static KafkaTracing create(MessagingTracing messagingTracing) {
        return KafkaTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return KafkaTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    KafkaTracing(Builder builder) {
        this.messagingTracing = builder.messagingTracing;
        this.tracer = builder.messagingTracing.tracing().tracer();
        Propagation propagation = this.messagingTracing.tracing().propagation();
        this.producerExtractor = propagation.extractor(KafkaProducerRequest::getHeader);
        this.consumerExtractor = propagation.extractor(KafkaConsumerRequest::getHeader);
        this.processorExtractor = propagation.extractor(KafkaPropagation.GETTER);
        this.producerInjector = propagation.injector(KafkaProducerRequest::setHeader);
        this.consumerInjector = propagation.injector(KafkaConsumerRequest::setHeader);
        this.producerSampler = this.messagingTracing.producerSampler();
        this.consumerSampler = this.messagingTracing.consumerSampler();
        this.propagationKeys = new LinkedHashSet<String>(propagation.keys());
        this.remoteServiceName = builder.remoteServiceName;
    }

    public MessagingTracing messagingTracing() {
        return this.messagingTracing;
    }

    public <K, V> Consumer<K, V> consumer(Consumer<K, V> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer == null");
        }
        return new TracingConsumer<K, V>(consumer, this);
    }

    public <K, V> Producer<K, V> producer(Producer<K, V> producer) {
        if (producer == null) {
            throw new NullPointerException("producer == null");
        }
        return new TracingProducer<K, V>(producer, this);
    }

    public Span nextSpan(ConsumerRecord<?, ?> record) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearHeaders(this.processorExtractor, record.headers(), record.headers());
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            KafkaTracing.addTags(record, (SpanCustomizer)result);
        }
        return result;
    }

    <R> TraceContextOrSamplingFlags extractAndClearHeaders(TraceContext.Extractor<R> extractor, R request, Headers headers) {
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        if (!extracted.equals((Object)TraceContextOrSamplingFlags.EMPTY)) {
            this.clearHeaders(headers);
        }
        return extracted;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    void clearHeaders(Headers headers) {
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Header next = (Header)i.next();
            if (!this.propagationKeys.contains(next.key())) continue;
            i.remove();
        }
    }

    static void addTags(ConsumerRecord<?, ?> record, SpanCustomizer result) {
        if (record.key() instanceof String && !"".equals(record.key())) {
            result.tag("kafka.key", record.key().toString());
        }
        result.tag("kafka.topic", record.topic());
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "kafka";

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        @Deprecated
        public Builder writeB3SingleFormat(boolean writeB3SingleFormat) {
            return this;
        }

        public KafkaTracing build() {
            return new KafkaTracing(this);
        }
    }
}

