/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import me.ahoo.cosid.IdConverter;

public abstract class RadixIdConverter
implements IdConverter {
    static final char ZERO = '0';
    static final char NINE = '9';
    static final char UPPERCASE_A = 'A';
    static final int UPPERCASE_OFFSET = 10;
    static final char UPPERCASE_Z = 'Z';
    static final char LOWERCASE_A = 'a';
    static final int LOWERCASE_OFFSET = 36;
    static final char LOWERCASE_Z = 'z';
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char PAD_CHAR = '0';
    private final boolean padStart;
    private final int charSize;
    private final long maxId;

    protected RadixIdConverter(boolean padStart, int charSize) {
        Preconditions.checkArgument((charSize > 0 && charSize <= this.getMaxCharSize() ? 1 : 0) != 0, (String)"charSize cannot be greater than MAX_CHAR_SIZE[%s]!", (int)this.getMaxCharSize());
        this.padStart = padStart;
        this.charSize = charSize;
        this.maxId = this.getMaxCharSize() == charSize ? Long.MAX_VALUE : Double.valueOf(Math.pow(this.getRadix(), charSize)).longValue();
    }

    public static int offset(char digitChar) {
        if (digitChar >= '0' && digitChar <= '9') {
            return digitChar - 48;
        }
        if (digitChar >= 'A' && digitChar <= 'Z') {
            return digitChar - 65 + 10;
        }
        if (digitChar >= 'a' && digitChar <= 'z') {
            return digitChar - 97 + 36;
        }
        return -1;
    }

    public static int maxCharSize(int radix, int bits) {
        int divideTimes = 0;
        for (long maxId = -1L << bits ^ 0xFFFFFFFFFFFFFFFFL; maxId > 0L; maxId /= (long)radix) {
            ++divideTimes;
        }
        return divideTimes;
    }

    boolean isPadStart() {
        return this.padStart;
    }

    public int getCharSize() {
        return this.charSize;
    }

    abstract int getRadix();

    abstract int getMaxCharSize();

    @Override
    public String asString(long id) {
        Preconditions.checkArgument((id > -1L ? 1 : 0) != 0, (String)"id[%s] must be greater than -1!", (long)id);
        int maxCharSize = this.getMaxCharSize();
        if (this.charSize < maxCharSize) {
            Preconditions.checkArgument((id < this.maxId ? 1 : 0) != 0, (String)"id[%s] cannot be greater than maxId:[%s]!", (long)id, (long)this.maxId);
        }
        char[] buf = new char[this.charSize];
        int charIdx = this.charSize;
        int radix = this.getRadix();
        while (id > 0L) {
            int mod = (int)(id % (long)radix);
            buf[--charIdx] = digits[mod];
            id /= (long)radix;
        }
        if (this.padStart && charIdx > 0) {
            while (charIdx > 0) {
                buf[--charIdx] = 48;
            }
        }
        return new String(buf, charIdx, this.charSize - charIdx);
    }

    @Override
    public long asLong(String idString) {
        char firstChar = idString.charAt(0);
        if (firstChar < '0') {
            throw new NumberFormatException(Strings.lenientFormat((String)"For input string: [%s]!", (Object[])new Object[]{idString}));
        }
        long result = 0L;
        int charIdx = 0;
        int charLen = idString.length();
        if (charLen > this.charSize) {
            throw new NumberFormatException(Strings.lenientFormat((String)"For input string:[%s]. charLen cannot be greater than charSize:[%s]!", (Object[])new Object[]{idString, this.charSize}));
        }
        int radix = this.getRadix();
        while (charIdx < charLen) {
            char digitChar;
            int digit;
            if ((digit = RadixIdConverter.offset(digitChar = idString.charAt(charIdx++))) < 0) {
                throw new NumberFormatException(Strings.lenientFormat((String)"For input string:[%s]. digitChar:[%s]@[%s] !", (Object[])new Object[]{idString, Character.valueOf(digitChar), charIdx}));
            }
            result *= (long)radix;
            result += (long)digit;
        }
        return result;
    }
}

