/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.machine.MachineStateStorage;
import me.ahoo.cosid.machine.NamespacedInstanceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMachineStateStorage
implements MachineStateStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryMachineStateStorage.class);
    private final ConcurrentHashMap<NamespacedInstanceId, MachineState> states = new ConcurrentHashMap();

    @Override
    public MachineState get(String namespace, InstanceId instanceId) {
        return this.states.getOrDefault(new NamespacedInstanceId(namespace, instanceId), MachineState.NOT_FOUND);
    }

    @Override
    public void set(String namespace, int machineId, InstanceId instanceId) {
        NamespacedInstanceId namespacedInstanceId = new NamespacedInstanceId(namespace, instanceId);
        MachineState machineState = MachineState.of(machineId, System.currentTimeMillis());
        if (log.isInfoEnabled()) {
            log.info("Set : [{}] to [{}].", (Object)namespacedInstanceId, (Object)machineState);
        }
        this.states.put(namespacedInstanceId, machineState);
    }

    @Override
    public void remove(String namespace, InstanceId instanceId) {
        NamespacedInstanceId namespacedInstanceId = new NamespacedInstanceId(namespace, instanceId);
        if (log.isInfoEnabled()) {
            log.info("Remove : [{}].", (Object)namespace);
        }
        this.states.remove(namespacedInstanceId);
    }

    @Override
    public void clear(String namespace) {
        if (log.isInfoEnabled()) {
            log.info("Clear namespace : [{}].", (Object)namespace);
        }
        this.states.clear();
    }

    @Override
    public int size(String namespace) {
        return this.states.size();
    }

    @Override
    public boolean exists(String namespace, InstanceId instanceId) {
        return this.states.containsKey(new NamespacedInstanceId(namespace, instanceId));
    }
}

