/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.machine;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MachineState {
    public static final MachineState NOT_FOUND = MachineState.of(-1, -1L);
    public static final String STATE_DELIMITER = "|";
    private final int machineId;
    private final long lastTimeStamp;

    public MachineState(int machineId, long lastTimeStamp) {
        this.machineId = machineId;
        this.lastTimeStamp = lastTimeStamp;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public long getLastTimeStamp() {
        return this.lastTimeStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MachineState)) {
            return false;
        }
        MachineState that = (MachineState)o;
        return this.getMachineId() == that.getMachineId();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getMachineId()});
    }

    public String toString() {
        return "MachineState{machineId=" + this.machineId + ", lastTimeStamp=" + this.lastTimeStamp + '}';
    }

    public String toStateString() {
        return Strings.lenientFormat((String)"%s%s%s", (Object[])new Object[]{this.machineId, STATE_DELIMITER, this.lastTimeStamp});
    }

    public static MachineState of(int machineId, long lastStamp) {
        return new MachineState(machineId, lastStamp);
    }

    public static MachineState of(int machineId) {
        return MachineState.of(machineId, System.currentTimeMillis());
    }

    public static MachineState of(String stateString) {
        List stateSplits = Splitter.on((String)STATE_DELIMITER).omitEmptyStrings().splitToList((CharSequence)stateString);
        if (stateSplits.size() != 2) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Machine status data:[{%s}] format error.", (Object[])new Object[]{stateString}));
        }
        int machineId = Integer.parseInt((String)stateSplits.get(0));
        long lastStamp = Long.parseLong((String)stateSplits.get(1));
        return MachineState.of(machineId, lastStamp);
    }
}

