/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.provider;

import com.google.common.base.Strings;
import java.util.Optional;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.IdGeneratorDecorator;
import me.ahoo.cosid.provider.DefaultIdGeneratorProvider;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.provider.NotFoundIdGeneratorException;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.snowflake.SnowflakeFriendlyId;
import me.ahoo.cosid.snowflake.SnowflakeId;

public final class LazyIdGenerator
implements IdGeneratorDecorator {
    private final String generatorName;
    private IdGenerator lazyIdGen;
    private final IdGeneratorProvider idGeneratorProvider;

    public LazyIdGenerator(String generatorName) {
        this(generatorName, DefaultIdGeneratorProvider.INSTANCE);
    }

    public LazyIdGenerator(String generatorName, IdGeneratorProvider idGeneratorProvider) {
        this.generatorName = generatorName;
        this.idGeneratorProvider = idGeneratorProvider;
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public IdGenerator tryGet(boolean required) {
        if (null != this.lazyIdGen) {
            return this.lazyIdGen;
        }
        String generatorName = this.getGeneratorName();
        Optional<IdGenerator> idGeneratorOp = this.idGeneratorProvider.get(generatorName);
        if (idGeneratorOp.isPresent()) {
            this.lazyIdGen = idGeneratorOp.get();
            return this.lazyIdGen;
        }
        if (required) {
            throw new NotFoundIdGeneratorException(generatorName);
        }
        return null;
    }

    public SnowflakeId asSnowflakeId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (null == idGenerator) {
            return null;
        }
        if (idGenerator instanceof SnowflakeId) {
            return (SnowflakeId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SnowflakeId!", (Object[])new Object[]{this.generatorName}));
    }

    public SnowflakeFriendlyId asFriendlyId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (null == idGenerator) {
            return null;
        }
        if (idGenerator instanceof SnowflakeFriendlyId) {
            return (SnowflakeFriendlyId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SnowflakeFriendlyId!", (Object[])new Object[]{this.generatorName}));
    }

    public SegmentId asSegmentId(boolean required) {
        IdGenerator idGenerator = this.tryGet(required);
        if (null == idGenerator) {
            return null;
        }
        if (idGenerator instanceof SegmentId) {
            return (SegmentId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"IdGenerator:[%s] is not instanceof SegmentId!", (Object[])new Object[]{this.generatorName}));
    }

    @Override
    public IdGenerator getActual() {
        return this.tryGet(true);
    }

    @Override
    public IdConverter idConverter() {
        return this.getActual().idConverter();
    }
}

