/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import me.ahoo.cosid.segment.DefaultIdSegment;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentChain;
import me.ahoo.cosid.segment.MergedIdSegment;
import me.ahoo.cosid.util.Clock;

public interface IdSegmentDistributor {
    public static final int DEFAULT_SEGMENTS = 1;
    public static final long DEFAULT_OFFSET = 0L;
    public static final long DEFAULT_STEP = 100L;

    public String getNamespace();

    public String getName();

    default public String getNamespacedName() {
        return IdSegmentDistributor.getNamespacedName(this.getNamespace(), this.getName());
    }

    public static String getNamespacedName(String namespace, String name) {
        return namespace + "." + name;
    }

    public long getStep();

    default public long getStep(int segments) {
        return Math.multiplyExact(this.getStep(), (long)segments);
    }

    public long nextMaxId(long var1);

    default public long nextMaxId() {
        return this.nextMaxId(this.getStep());
    }

    default public IdSegment nextIdSegment() {
        return this.nextIdSegment(Long.MAX_VALUE);
    }

    default public IdSegment nextIdSegment(long ttl) {
        Preconditions.checkArgument((ttl > 0L ? 1 : 0) != 0, (String)"ttl:[%s] must be greater than 0.", (long)ttl);
        long maxId = this.nextMaxId();
        return new DefaultIdSegment(maxId, this.getStep(), Clock.CACHE.secondTime(), ttl);
    }

    default public IdSegment nextIdSegment(int segments, long ttl) {
        Preconditions.checkArgument((segments > 0 ? 1 : 0) != 0, (String)"segments:[%s] must be greater than 0.", (int)segments);
        Preconditions.checkArgument((ttl > 0L ? 1 : 0) != 0, (String)"ttl:[%s] must be greater than 0.", (long)ttl);
        long totalStep = this.getStep(segments);
        long maxId = this.nextMaxId(totalStep);
        DefaultIdSegment nextIdSegment = new DefaultIdSegment(maxId, totalStep, Clock.CACHE.secondTime(), ttl);
        return new MergedIdSegment(segments, nextIdSegment);
    }

    default public IdSegmentChain nextIdSegmentChain(IdSegmentChain previousChain) {
        return this.nextIdSegmentChain(previousChain, 1, Long.MAX_VALUE);
    }

    default public IdSegmentChain nextIdSegmentChain(IdSegmentChain previousChain, int segments, long ttl) {
        if (1 == segments) {
            IdSegment nextIdSegment = this.nextIdSegment(ttl);
            return new IdSegmentChain(previousChain, nextIdSegment);
        }
        IdSegment nextIdSegment = this.nextIdSegment(segments, ttl);
        return new IdSegmentChain(previousChain, nextIdSegment);
    }

    public static void ensureStep(long step) {
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (String)"step:[%s] must be greater than 0!", (long)step);
    }

    @VisibleForTesting
    public static class Mock
    implements IdSegmentDistributor {
        private static final AtomicInteger MOCK_COUNTER = new AtomicInteger();
        private final long step;
        private final String name;
        private final long ioWaiting;
        private final AtomicLong adder = new AtomicLong();

        public Mock() {
            this(100L, 220000);
        }

        public Mock(long step, int tps) {
            this.step = step;
            this.ioWaiting = TimeUnit.SECONDS.toNanos(1L) / (long)tps;
            this.name = "mock__" + MOCK_COUNTER.incrementAndGet();
        }

        @Override
        public String getNamespace() {
            return "__";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getStep() {
            return this.step;
        }

        @Override
        public long nextMaxId(long step) {
            LockSupport.parkNanos(this.ioWaiting);
            return this.adder.addAndGet(step);
        }
    }

    public static class Atomic
    implements IdSegmentDistributor {
        private static final AtomicInteger ATOMIC_COUNTER = new AtomicInteger();
        private final long step;
        private final String name;
        private final AtomicLong adder = new AtomicLong();

        public Atomic() {
            this(100L);
        }

        public Atomic(long step) {
            this.step = step;
            this.name = "atomic__" + ATOMIC_COUNTER.incrementAndGet();
        }

        @Override
        public String getNamespace() {
            return "__";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getStep() {
            return this.step;
        }

        @Override
        public long nextMaxId(long step) {
            return this.adder.addAndGet(step);
        }
    }
}

