/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SnowflakeIdState
implements Comparable<SnowflakeIdState> {
    private final long id;
    private final long machineId;
    private final long sequence;
    private final LocalDateTime timestamp;
    private final String friendlyId;

    SnowflakeIdState(long id, long machineId, long sequence, LocalDateTime timestamp, String friendlyId) {
        this.id = id;
        this.machineId = machineId;
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.friendlyId = friendlyId;
    }

    public static SnowflakeIdStateBuilder builder() {
        return new SnowflakeIdStateBuilder();
    }

    public long getId() {
        return this.id;
    }

    public long getMachineId() {
        return this.machineId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other) || !this.getClass().isInstance(other)) {
            return false;
        }
        SnowflakeIdState that = (SnowflakeIdState)other;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return this.friendlyId;
    }

    @Override
    public int compareTo(SnowflakeIdState other) {
        return Long.compare(this.id, other.id);
    }

    public static class SnowflakeIdStateBuilder {
        private long id;
        private long machineId;
        private long sequence;
        private LocalDateTime timestamp;
        private String friendlyId;

        SnowflakeIdStateBuilder() {
        }

        public SnowflakeIdStateBuilder id(long id) {
            this.id = id;
            return this;
        }

        public SnowflakeIdStateBuilder machineId(long machineId) {
            this.machineId = machineId;
            return this;
        }

        public SnowflakeIdStateBuilder sequence(long sequence) {
            this.sequence = sequence;
            return this;
        }

        public SnowflakeIdStateBuilder timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SnowflakeIdStateBuilder friendlyId(String friendlyId) {
            this.friendlyId = friendlyId;
            return this;
        }

        public SnowflakeIdState build() {
            return new SnowflakeIdState(this.id, this.machineId, this.sequence, this.timestamp, this.friendlyId);
        }

        public String toString() {
            return "SnowflakeIdState.SnowflakeIdStateBuilder(id=" + this.id + ", machineId=" + this.machineId + ", sequence=" + this.sequence + ", timestamp=" + this.timestamp + ", friendlyId=" + this.friendlyId + ")";
        }
    }
}

