/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.accessevent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.logstash.logback.composite.accessevent.HeaderFilter;

public class IncludeExcludeHeaderFilter
implements HeaderFilter {
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    @Override
    public boolean includeHeader(String headerName, String headerValue) {
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return true;
        }
        if (this.excludes.isEmpty()) {
            return this.includes.contains(headerName.toLowerCase());
        }
        if (this.includes.isEmpty()) {
            return !this.excludes.contains(headerName.toLowerCase());
        }
        throw new IllegalStateException(String.format("Both includes (%s) and excludes (%s) cannot be configured at the same time.  Only one or the other, or neither can be configured.", this.includes, this.excludes));
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public Set<String> getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    public boolean addInclude(String include) {
        return this.includes.add(include.toLowerCase());
    }

    public boolean removeInclude(String include) {
        return this.includes.remove(include.toLowerCase());
    }

    public boolean addExclude(String exclude) {
        return this.excludes.add(exclude.toLowerCase());
    }

    public boolean removeExclude(String exclude) {
        return this.excludes.remove(exclude.toLowerCase());
    }
}

