/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.File;
import org.fit.pdfdom.resource.EmbedAsBase64Handler;
import org.fit.pdfdom.resource.HtmlResourceHandler;
import org.fit.pdfdom.resource.IgnoreResourceHandler;
import org.fit.pdfdom.resource.SaveResourceToDirHandler;

public class PDFDomTreeConfig {
    private HtmlResourceHandler imageHandler;
    private HtmlResourceHandler fontHandler;

    public static PDFDomTreeConfig createDefaultConfig() {
        PDFDomTreeConfig config = new PDFDomTreeConfig();
        config.setFontHandler(PDFDomTreeConfig.embedAsBase64());
        config.setImageHandler(PDFDomTreeConfig.embedAsBase64());
        return config;
    }

    public static HtmlResourceHandler embedAsBase64() {
        return new EmbedAsBase64Handler();
    }

    public static HtmlResourceHandler saveToDirectory(File directory) {
        return new SaveResourceToDirHandler(directory);
    }

    public static HtmlResourceHandler ignoreResource() {
        return new IgnoreResourceHandler();
    }

    private PDFDomTreeConfig() {
    }

    public HtmlResourceHandler getImageHandler() {
        return this.imageHandler;
    }

    public void setImageHandler(HtmlResourceHandler imageHandler) {
        this.imageHandler = imageHandler;
    }

    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    public void setFontHandler(HtmlResourceHandler fontHandler) {
        this.fontHandler = fontHandler;
    }
}

