/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.exception.resolver;

import net.stickycode.exception.BlankParameterException;
import net.stickycode.exception.InvalidParameterException;
import net.stickycode.exception.NullParameterException;
import net.stickycode.exception.resolver.Fragment;
import net.stickycode.exception.resolver.Fragments;
import net.stickycode.exception.resolver.ThrowablesCannotBeParametersException;
import net.stickycode.exception.resolver.TooManyArgumentsException;
import net.stickycode.exception.resolver.TooManyPlaceHoldersException;

public class ParameterResolver {
    ParameterResolver() {
    }

    public static String resolve(String message, Object ... arguments) throws InvalidParameterException {
        if (message == null) {
            throw new NullParameterException("Message should not be null", new Object[0]);
        }
        if (arguments == null) {
            throw new NullParameterException("Arguments should not be null, you can just leave the arguments off if there aren't any, but never pass null.", new Object[0]);
        }
        if (message.trim().length() == 0) {
            throw new BlankParameterException("Message should not be blank", new Object[0]);
        }
        return ParameterResolver.resolveMessage(message, arguments);
    }

    private static String resolveMessage(String message, Object[] parameters) {
        Fragments fragments = new Fragments(message);
        int i = 0;
        StringBuilder b = new StringBuilder();
        for (Fragment fragment : fragments) {
            if (fragment.isText()) {
                b.append(fragment.getValue());
                continue;
            }
            if (i >= parameters.length) {
                throw new TooManyPlaceHoldersException(parameters.length, i, message);
            }
            if (fragment.isParameter()) {
                b.append(ParameterResolver.map(ParameterResolver.filterThrowableParameters(parameters[i])));
                ++i;
            }
            if (!fragment.isQuote()) continue;
            b.append("'").append(ParameterResolver.map(ParameterResolver.filterThrowableParameters(parameters[i]))).append("'");
            ++i;
        }
        if (i < parameters.length) {
            throw new TooManyArgumentsException(parameters, i, message);
        }
        return b.toString();
    }

    private static Object map(Object object) {
        if (object.getClass() == Class.class) {
            return ((Class)object).getSimpleName();
        }
        return object;
    }

    private static Object filterThrowableParameters(Object object) {
        if (object == null) {
            throw new NullParameterException("Passing null parameters to exception constructors is not good practice", new Object[0]);
        }
        if (object instanceof Throwable) {
            throw new ThrowablesCannotBeParametersException((Throwable)object);
        }
        return object;
    }
}

