/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import net.ymate.framework.commons.ICmdOutputHandler;

public class ConsoleCmdExecutor {
    public static String exec(String ... command) throws Exception {
        return ConsoleCmdExecutor.exec(Arrays.asList(command));
    }

    public static String exec(List<String> command) throws Exception {
        return ConsoleCmdExecutor.exec(command, new ICmdOutputHandler<String>(){

            @Override
            public String handle(BufferedReader reader) throws Exception {
                StringBuilder _sb = new StringBuilder();
                String _line = null;
                while ((_line = reader.readLine()) != null) {
                    _sb.append(_line).append("\r\n");
                }
                return _sb.toString();
            }
        });
    }

    public static <T> T exec(String[] command, ICmdOutputHandler<T> handler) throws Exception {
        return ConsoleCmdExecutor.exec(Arrays.asList(command), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T exec(List<String> command, ICmdOutputHandler<T> handler) throws Exception {
        Process _process = null;
        BufferedReader _outputBuff = null;
        try {
            _process = new ProcessBuilder(command).redirectErrorStream(true).start();
            _outputBuff = new BufferedReader(new InputStreamReader(_process.getInputStream()), 1024);
            T _result = handler.handle(_outputBuff);
            _process.waitFor();
            T t = _result;
            return t;
        }
        finally {
            if (_process != null) {
                _process.destroy();
            }
            if (_outputBuff != null) {
                _outputBuff.close();
            }
        }
    }
}

