/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ymate.framework.commons.ConsoleCmdExecutor;
import net.ymate.framework.commons.ICmdOutputHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFmpegHelper {
    private static final Log _LOG = LogFactory.getLog(FFmpegHelper.class);
    private String __ffmpegPath;
    private String __mediaFile;

    public static FFmpegHelper create(String ffmpegPath) {
        return new FFmpegHelper(ffmpegPath);
    }

    private FFmpegHelper(String ffmpegPath) {
        if (StringUtils.isBlank((String)ffmpegPath) && this.__doCheckFile(ffmpegPath)) {
            throw new IllegalArgumentException("Argument ffmpegPath illegal.");
        }
        this.__ffmpegPath = ffmpegPath;
    }

    public FFmpegHelper bind(String mediaFile) {
        if (!this.__doCheckFile(mediaFile)) {
            throw new IllegalArgumentException("Argument mediaFile illegal.");
        }
        this.__mediaFile = mediaFile;
        return this;
    }

    public FFmpegHelper bind(File mediaFile) {
        return this.bind(mediaFile == null ? null : mediaFile.getPath());
    }

    private boolean __doCheckFile(String file) {
        File _file = new File(file);
        return _file.exists() && _file.isFile();
    }

    private int __doGetTimeLength(String timelen) {
        int min = 0;
        String[] _strArr = timelen.split(":");
        if (_strArr[0].compareTo("0") > 0) {
            min += Integer.valueOf(_strArr[0]) * 60 * 60;
        }
        if (_strArr[1].compareTo("0") > 0) {
            min += Integer.valueOf(_strArr[1]) * 60;
        }
        if (_strArr[2].compareTo("0") > 0) {
            min += Math.round(Float.valueOf(_strArr[2]).floatValue());
        }
        return min;
    }

    public MediaInfo getMediaInfo() {
        try {
            String _outputStr = ConsoleCmdExecutor.exec(this.__ffmpegPath, "-i", this.__mediaFile);
            _LOG.info((Object)_outputStr);
            String regexDuration = "Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s";
            String regexVideo = "Video: (.*?), (.*?), (.*?)[,\\s]";
            String regexAudio = "Audio: (\\w*), (\\d*) Hz";
            MediaInfo _info = new MediaInfo();
            Pattern pattern = Pattern.compile(regexDuration);
            Matcher m = pattern.matcher(_outputStr);
            if (m.find()) {
                _info.setStart(m.group(2));
                _info.setBitrates(m.group(3));
                _info.setTime(this.__doGetTimeLength(m.group(1)));
            }
            if ((m = (pattern = Pattern.compile(regexVideo)).matcher(_outputStr)).find()) {
                _info.setVideoEncodingFormat(m.group(1));
                _info.setVideoFormat(m.group(2));
                _info.setResolution(m.group(3));
            }
            if ((m = (pattern = Pattern.compile(regexAudio)).matcher(_outputStr)).find()) {
                _info.setAudioEncodingFormat(m.group(1));
                _info.setAudioSamplingRate(m.group(2));
            }
            return _info;
        }
        catch (Exception e) {
            _LOG.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public String audioToMP3(File outputMP3) {
        try {
            ConsoleCmdExecutor.exec(new String[]{this.__ffmpegPath, "-i", this.__mediaFile, outputMP3.getPath()}, new WriteConsoleLog());
            return outputMP3.getPath();
        }
        catch (Exception e) {
            _LOG.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public String screenshotVideo(String startSecond, String imageSize, File outputJPG) {
        ArrayList<String> _cmd = new ArrayList<String>();
        _cmd.add(this.__ffmpegPath);
        _cmd.add("-i");
        _cmd.add(this.__mediaFile);
        _cmd.add("-y");
        _cmd.add("-f");
        _cmd.add("mjpeg");
        if (StringUtils.isNotBlank((String)startSecond)) {
            _cmd.add("-ss");
            _cmd.add(startSecond);
        }
        _cmd.add("-t");
        _cmd.add("0.001");
        if (StringUtils.isNotBlank((String)imageSize)) {
            _cmd.add("-s");
            _cmd.add(imageSize);
        }
        _cmd.add(outputJPG.getPath());
        try {
            ConsoleCmdExecutor.exec(_cmd, new WriteConsoleLog());
            return outputJPG.getPath();
        }
        catch (Exception e) {
            _LOG.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public String videoToFLV(String imageSize, File outputFLV) {
        ArrayList<String> _cmd = new ArrayList<String>();
        _cmd.add(this.__ffmpegPath);
        _cmd.add("-y");
        _cmd.add("-i");
        _cmd.add(this.__mediaFile);
        _cmd.add("-ab");
        _cmd.add("56");
        _cmd.add("-ar");
        _cmd.add("22050");
        _cmd.add("-b");
        _cmd.add("500");
        if (StringUtils.isNotBlank((String)imageSize)) {
            _cmd.add("-s");
            _cmd.add(imageSize);
        }
        _cmd.add(outputFLV.getPath());
        try {
            ConsoleCmdExecutor.exec(_cmd, new WriteConsoleLog());
            return outputFLV.getPath();
        }
        catch (Exception e) {
            _LOG.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public static class MediaInfo
    implements Serializable {
        private String start;
        private String bitrates;
        private int time;
        private String videoEncodingFormat;
        private String videoFormat;
        private String resolution;
        private String audioEncodingFormat;
        private String audioSamplingRate;

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getBitrates() {
            return this.bitrates;
        }

        public void setBitrates(String bitrates) {
            this.bitrates = bitrates;
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public String getVideoEncodingFormat() {
            return this.videoEncodingFormat;
        }

        public void setVideoEncodingFormat(String videoEncodingFormat) {
            this.videoEncodingFormat = videoEncodingFormat;
        }

        public String getVideoFormat() {
            return this.videoFormat;
        }

        public void setVideoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
        }

        public String getResolution() {
            return this.resolution;
        }

        public void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public String getAudioEncodingFormat() {
            return this.audioEncodingFormat;
        }

        public void setAudioEncodingFormat(String audioEncodingFormat) {
            this.audioEncodingFormat = audioEncodingFormat;
        }

        public String getAudioSamplingRate() {
            return this.audioSamplingRate;
        }

        public void setAudioSamplingRate(String audioSamplingRate) {
            this.audioSamplingRate = audioSamplingRate;
        }
    }

    class WriteConsoleLog
    implements ICmdOutputHandler<Void> {
        WriteConsoleLog() {
        }

        @Override
        public Void handle(BufferedReader reader) throws Exception {
            String _line = null;
            while ((_line = reader.readLine()) != null) {
                _LOG.info((Object)_line);
            }
            return null;
        }
    }
}

