/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;

public interface IFileWrapper {
    public boolean hasError();

    public String getErrorMsg();

    public String getFileName();

    public String getName();

    public String getSuffix();

    public long getContentLength();

    public String getContentType();

    public InputStream getInputStream() throws IOException;

    public void writeTo(File var1) throws IOException;

    public ContentBody toContentBody();

    public static class NEW
    implements IFileWrapper {
        private boolean __hasError;
        private String __errMsg;
        private String __fileName;
        private String __name;
        private String __suffix;
        private String __contentType;
        private long __contentLength;
        private InputStream __sourceInputStream;

        public NEW(String fileName, String contentType, long contentLength, InputStream sourceInputStream) {
            this.__fileName = fileName;
            if (StringUtils.isNotBlank((String)this.__fileName)) {
                this.__name = StringUtils.substringBefore((String)StringUtils.replace((String)this.__fileName, (String)"\"", (String)""), (String)".");
                this.__suffix = net.ymate.platform.core.util.FileUtils.getExtName((String)this.__fileName);
            }
            this.__contentType = contentType;
            this.__contentLength = contentLength;
            this.__sourceInputStream = sourceInputStream;
        }

        public NEW(String contentType, long contentLength, InputStream sourceInputStream) {
            this.__contentType = contentType;
            this.__contentLength = contentLength;
            this.__sourceInputStream = sourceInputStream;
        }

        public NEW(String errMsg) {
            this.__hasError = true;
            this.__errMsg = errMsg;
        }

        @Override
        public boolean hasError() {
            return this.__hasError;
        }

        @Override
        public String getErrorMsg() {
            return this.__errMsg;
        }

        @Override
        public String getFileName() {
            return this.__fileName;
        }

        @Override
        public String getName() {
            return this.__name;
        }

        @Override
        public String getSuffix() {
            return this.__suffix;
        }

        @Override
        public long getContentLength() {
            return this.__contentLength;
        }

        @Override
        public String getContentType() {
            return this.__contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.__sourceInputStream;
        }

        @Override
        public void writeTo(File distFile) throws IOException {
            FileUtils.copyInputStreamToFile((InputStream)this.__sourceInputStream, (File)distFile);
        }

        @Override
        public ContentBody toContentBody() {
            return new InputStreamBody(this.__sourceInputStream, ContentType.create((String)this.__contentType), this.__fileName){

                public long getContentLength() {
                    return NEW.this.__contentLength;
                }
            };
        }
    }
}

