/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public interface IHttpResponse {
    public int getStatusCode();

    public String getContent();

    public String getContentType();

    public long getContentLength();

    public String getContentEncoding();

    public Map<String, String> getHeaders();

    public static class NEW
    implements IHttpResponse {
        private int __statusCode;
        private String __content;
        private String __contentType;
        private String __contentEncoding;
        private long __contentLength;
        private Map<String, String> __headers;

        public NEW(HttpResponse response) throws IOException {
            this.__statusCode = response.getStatusLine().getStatusCode();
            this.__content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            Header _header = response.getEntity().getContentEncoding();
            if (_header != null) {
                this.__contentEncoding = _header.getValue();
            }
            if ((_header = response.getEntity().getContentType()) != null) {
                this.__contentType = _header.getValue();
            }
            this.__contentLength = response.getEntity().getContentLength();
            this.__headers = new HashMap<String, String>();
            Header[] _headersArr = response.getAllHeaders();
            if (_headersArr != null) {
                for (Header _element : _headersArr) {
                    this.__headers.put(_element.getName(), _element.getValue());
                }
            }
        }

        @Override
        public int getStatusCode() {
            return this.__statusCode;
        }

        @Override
        public String getContent() {
            return this.__content;
        }

        @Override
        public String getContentType() {
            return this.__contentType;
        }

        @Override
        public long getContentLength() {
            return this.__contentLength;
        }

        @Override
        public String getContentEncoding() {
            return this.__contentEncoding;
        }

        @Override
        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.__headers);
        }

        public String toString() {
            return "{__statusCode=" + this.__statusCode + ", __content='" + this.__content + '\'' + ", __contentType='" + this.__contentType + '\'' + ", __contentEncoding='" + this.__contentEncoding + '\'' + ", __contentLength=" + this.__contentLength + ", __headers=" + this.__headers + '}';
        }
    }
}

