/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.math.BigDecimal;
import net.ymate.platform.core.lang.BlurObject;

public class MathCalcHelper {
    private static final int DEFAULT_DIV_SCALE = 10;
    private BigDecimal __value;
    private int __scale = -1;
    private int __roundingMode = -1;

    public static MathCalcHelper bind(double value) {
        return new MathCalcHelper(value);
    }

    public static MathCalcHelper bind(String value) {
        return new MathCalcHelper(value);
    }

    public static MathCalcHelper bind(BigDecimal value) {
        return new MathCalcHelper(value);
    }

    private MathCalcHelper(double value) {
        this.__value = new BigDecimal(Double.toString(value));
    }

    private MathCalcHelper(String value) {
        this.__value = new BigDecimal(value);
    }

    private MathCalcHelper(BigDecimal value) {
        this.__value = value;
    }

    public MathCalcHelper scale(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("the scale must be a positive integer or zero.");
        }
        this.__scale = scale;
        return this;
    }

    public MathCalcHelper roundUp() {
        this.__roundingMode = 0;
        return this;
    }

    public MathCalcHelper roundDown() {
        this.__roundingMode = 1;
        return this;
    }

    public MathCalcHelper roundCeiling() {
        this.__roundingMode = 2;
        return this;
    }

    public MathCalcHelper roundFloor() {
        this.__roundingMode = 3;
        return this;
    }

    public MathCalcHelper roundHalfUp() {
        this.__roundingMode = 4;
        return this;
    }

    public MathCalcHelper roundHalfDown() {
        this.__roundingMode = 5;
        return this;
    }

    public MathCalcHelper roundHalfEven() {
        this.__roundingMode = 6;
        return this;
    }

    public MathCalcHelper roundUnnecessary() {
        this.__roundingMode = 7;
        return this;
    }

    public BlurObject add(double value) {
        return BlurObject.bind((Object)this.__value.add(new BigDecimal(Double.toString(value))));
    }

    public BlurObject add(String value) {
        return BlurObject.bind((Object)this.__value.add(new BigDecimal(value)));
    }

    public BlurObject add(BigDecimal value) {
        return BlurObject.bind((Object)this.__value.add(value));
    }

    public BlurObject subtract(double value) {
        return BlurObject.bind((Object)this.__value.subtract(new BigDecimal(Double.toString(value))));
    }

    public BlurObject subtract(String value) {
        return BlurObject.bind((Object)this.__value.subtract(new BigDecimal(value)));
    }

    public BlurObject subtract(BigDecimal value) {
        return BlurObject.bind((Object)this.__value.subtract(value));
    }

    public BlurObject multiply(double value) {
        return BlurObject.bind((Object)this.__value.multiply(new BigDecimal(Double.toString(value))));
    }

    public BlurObject multiply(String value) {
        return BlurObject.bind((Object)this.__value.multiply(new BigDecimal(value)));
    }

    public BlurObject multiply(BigDecimal value) {
        return BlurObject.bind((Object)this.__value.multiply(value));
    }

    public BlurObject divide(double value) {
        return this.divide(new BigDecimal(Double.toString(value)));
    }

    public BlurObject divide(String value) {
        return this.divide(new BigDecimal(value));
    }

    public BlurObject divide(BigDecimal value) {
        return BlurObject.bind((Object)this.__value.divide(value, this.__scale >= 0 ? this.__scale : 10, this.__roundingMode >= 0 ? this.__roundingMode : 6));
    }

    public BlurObject round() {
        return BlurObject.bind((Object)this.__value.setScale(this.__scale >= 0 ? this.__scale : 10, this.__roundingMode >= 0 ? this.__roundingMode : 6));
    }
}

