/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.core.util.UUIDUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParamUtils {
    private static final Log _LOG = LogFactory.getLog(ParamUtils.class);

    public static String buildQueryParamStr(Map<String, ?> params, boolean encode, String charset) {
        Object[] _keys = params.keySet().toArray(new String[params.size()]);
        Arrays.sort(_keys);
        StringBuilder _paramSB = new StringBuilder();
        for (Object _key : _keys) {
            Object _value = params.get(_key);
            if (_value == null) continue;
            if (_value.getClass().isArray()) {
                for (Object _v : (Object[])_value) {
                    ParamUtils.__doAppendParamValue((String)_key, _v, _paramSB, encode, charset);
                }
                continue;
            }
            ParamUtils.__doAppendParamValue((String)_key, _value, _paramSB, encode, charset);
        }
        return _paramSB.toString();
    }

    private static void __doAppendParamValue(String _key, Object _v, StringBuilder _paramSB, boolean encode, String charset) {
        if (_paramSB.length() > 0) {
            _paramSB.append("&");
        }
        String _valueStr = _v.toString();
        if (encode) {
            try {
                _paramSB.append(_key).append("=").append(URLEncoder.encode(_valueStr, StringUtils.defaultIfBlank((String)charset, (String)"UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
            }
        } else {
            _paramSB.append(_key).append("=").append(_valueStr);
        }
    }

    public static String appendQueryParamValue(String url, Map<String, String> params, boolean encode, String charset) {
        if (params != null && !params.isEmpty()) {
            StringBuilder _paramSB = new StringBuilder(url);
            if (!url.contains("?")) {
                _paramSB.append("?");
            } else {
                _paramSB.append("&");
            }
            for (Map.Entry<String, String> _param : params.entrySet()) {
                if (encode) {
                    try {
                        _paramSB.append(_param.getKey()).append("=").append(URLEncoder.encode(_param.getValue(), StringUtils.defaultIfBlank((String)charset, (String)"UTF-8"))).append("&");
                    }
                    catch (UnsupportedEncodingException e) {
                        _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
                    }
                    continue;
                }
                _paramSB.append(_param.getKey()).append("=").append(_param.getValue()).append("&");
            }
            if (_paramSB.length() > 0 && _paramSB.charAt(_paramSB.length() - 1) == '&') {
                _paramSB.setLength(_paramSB.length() - 1);
            }
            return _paramSB.toString();
        }
        return url;
    }

    public static Map<String, String> convertParamMap(Map<String, Object> sourceMap) {
        HashMap<String, String> _returnValue = new HashMap<String, String>(sourceMap.size());
        for (Map.Entry<String, Object> _ent : sourceMap.entrySet()) {
            if (_ent.getValue() == null) continue;
            _returnValue.put(_ent.getKey(), BlurObject.bind((Object)_ent.getValue()).toStringValue());
        }
        return _returnValue;
    }

    public static Map<String, String> parseQueryParamStr(String paramStr) {
        return ParamUtils.parseQueryParamStr(paramStr, false, null);
    }

    public static Map<String, String> parseQueryParamStr(String paramStr, boolean decode, String charset) {
        String[] _paramArr = StringUtils.split((String)paramStr, (char)'&');
        HashMap<String, String> _returnValue = new HashMap<String, String>(_paramArr.length);
        for (String _param : _paramArr) {
            int nPos = _param.indexOf(61);
            int nLen = _param.length();
            String strKey = _param.substring(0, nPos);
            String strValue = _param.substring(nPos + 1, nLen);
            if (decode) {
                try {
                    strValue = URLDecoder.decode(strValue, StringUtils.defaultIfBlank((String)charset, (String)"UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
                }
            }
            _returnValue.put(strKey, strValue);
        }
        return _returnValue;
    }

    public static String buildActionForm(String actionUrl, boolean usePost, Map<String, String> params) {
        StringBuilder _payHtml = new StringBuilder();
        _payHtml.append("<form id=\"_payment_submit\" name=\"_payment_submit\" action=\"").append(actionUrl).append("\" method=\"").append(usePost ? "POST" : "GET").append("\">");
        for (Map.Entry<String, String> _entry : params.entrySet()) {
            if (_entry.getKey() == null) continue;
            _payHtml.append("<input type=\"hidden\" name=\"").append(_entry.getKey()).append("\" value=\"").append(_entry.getValue()).append("\"/>");
        }
        _payHtml.append("<input type=\"submit\" value=\"doSubmit\" style=\"display:none;\"></form>");
        _payHtml.append("<script>document.forms['_payment_submit'].submit();</script>");
        return _payHtml.toString();
    }

    public static String createNonceStr() {
        return UUIDUtils.randomStr((int)UUIDUtils.randomInt((int)6, (int)32), (boolean)false).toLowerCase();
    }

    public static String createSignature(Map<String, String> queryParamMap, boolean encode, String ... extraParams) {
        StringBuilder _queryParamStr = new StringBuilder(ParamUtils.buildQueryParamStr(queryParamMap, encode, null));
        if (extraParams != null && extraParams.length > 0) {
            for (String _extraParam : extraParams) {
                _queryParamStr.append("&").append(_extraParam);
            }
        }
        return DigestUtils.md5Hex((String)_queryParamStr.toString()).toUpperCase();
    }
}

