/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathHelper {
    public static final DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
    public static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private XPath __path;
    private Document __document;

    public XPathHelper(Document document) {
        this.__path = xpathFactory.newXPath();
        this.__document = document;
    }

    public XPathHelper(InputSource inputSource) throws Exception {
        this(documentFactory.newDocumentBuilder().parse(inputSource));
    }

    public XPathHelper(String content) throws Exception {
        StringReader _reader = null;
        try {
            _reader = new StringReader(content);
            this.__document = documentFactory.newDocumentBuilder().parse(new InputSource(_reader));
            this.__path = xpathFactory.newXPath();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(_reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)_reader);
    }

    public Document getDocument() {
        return this.__document;
    }

    public Map<String, Object> toMap() {
        return this.toMap(this.__document.getDocumentElement());
    }

    public Map<String, Object> toMap(Node parent) {
        HashMap<String, Object> _returnMap = new HashMap<String, Object>();
        NodeList _nodes = parent.getChildNodes();
        for (int _idx = 0; _idx < _nodes.getLength(); ++_idx) {
            Node _node = _nodes.item(_idx);
            if (_node.getNodeType() != 1 || !_node.hasChildNodes() || _node.getChildNodes().getLength() != 1) continue;
            _returnMap.put(_node.getNodeName(), _node.getTextContent());
        }
        return _returnMap;
    }

    private Object __doEvaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        return this.__path.evaluate(expression, null == item ? this.__document : item, returnType);
    }

    public String getStringValue(String expression) throws XPathExpressionException {
        return (String)this.__doEvaluate(expression, null, XPathConstants.STRING);
    }

    public Number getNumberValue(String expression) throws XPathExpressionException {
        return (Number)this.__doEvaluate(expression, null, XPathConstants.NUMBER);
    }

    public Boolean getBooleanValue(String expression) throws XPathExpressionException {
        return (Boolean)this.__doEvaluate(expression, null, XPathConstants.BOOLEAN);
    }

    public Node getNode(String expression) throws XPathExpressionException {
        return (Node)this.__doEvaluate(expression, null, XPathConstants.NODE);
    }

    public NodeList getNodeList(String expression) throws XPathExpressionException {
        return (NodeList)this.__doEvaluate(expression, null, XPathConstants.NODESET);
    }

    public String getStringValue(Object item, String expression) throws XPathExpressionException {
        return (String)this.__doEvaluate(expression, item, XPathConstants.STRING);
    }

    public Number getNumberValue(Object item, String expression) throws XPathExpressionException {
        return (Number)this.__doEvaluate(expression, item, XPathConstants.NUMBER);
    }

    public Boolean getBooleanValue(Object item, String expression) throws XPathExpressionException {
        return (Boolean)this.__doEvaluate(expression, item, XPathConstants.BOOLEAN);
    }

    public Node getNode(Object item, String expression) throws XPathExpressionException {
        return (Node)this.__doEvaluate(expression, item, XPathConstants.NODE);
    }

    public NodeList getNodeList(Object item, String expression) throws XPathExpressionException {
        return (NodeList)this.__doEvaluate(expression, item, XPathConstants.NODESET);
    }
}

