/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineDelegationTokenSecretManagerService
extends AbstractService {
    private TimelineDelegationTokenSecretManager secretManager = null;
    private InetSocketAddress serviceAddr = null;

    public TimelineDelegationTokenSecretManagerService() {
        super(TimelineDelegationTokenSecretManagerService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long secretKeyInterval = conf.getLong("yarn.resourcemanager.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.resourcemanager.delegation.token.renew-interval", 86400000L);
        this.secretManager = new TimelineDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
        this.secretManager.startThreads();
        this.serviceAddr = TimelineUtils.getTimelineTokenServiceAddress((Configuration)this.getConfig());
        super.init(conf);
    }

    protected void serviceStop() throws Exception {
        this.secretManager.stopThreads();
        super.stop();
    }

    public TimelineDelegationTokenSecretManager getTimelineDelegationTokenSecretManager() {
        return this.secretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class TimelineDelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> {
        public TimelineDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public TimelineDelegationTokenIdentifier createIdentifier() {
            return new TimelineDelegationTokenIdentifier();
        }
    }
}

