/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic;

import java.util.List;
import java.util.StringJoiner;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.ComplexExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public class InsertValue {
    private final List<ExpressionSegment> values;

    public final String toString() {
        StringJoiner result = new StringJoiner(", ", "(", ")");
        for (int i = 0; i < this.values.size(); ++i) {
            result.add(this.getValue(i));
        }
        return result.toString();
    }

    private String getValue(int index) {
        ExpressionSegment expressionSegment = this.values.get(index);
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment segment = (ParameterMarkerExpressionSegment)expressionSegment;
            return ParameterMarkerType.QUESTION == segment.getParameterMarkerType() ? "?" : "$" + (segment.getParameterMarkerIndex() + 1);
        }
        if (expressionSegment instanceof LiteralExpressionSegment) {
            Object literals = ((LiteralExpressionSegment)expressionSegment).getLiterals();
            return literals instanceof String ? "'" + ((LiteralExpressionSegment)expressionSegment).getLiterals() + "'" : literals.toString();
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            return ((BinaryOperationExpression)expressionSegment).getText();
        }
        return ((ComplexExpressionSegment)expressionSegment).getText();
    }

    @Generated
    public InsertValue(List<ExpressionSegment> values) {
        this.values = values;
    }

    @Generated
    public List<ExpressionSegment> getValues() {
        return this.values;
    }
}

