/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class DropTest
extends AbstractGremlinTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_drop();

    public abstract Traversal<Vertex, Edge> get_g_V_outE_drop();

    public abstract Traversal<Vertex, VertexProperty> get_g_V_properties_drop();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")
    public void g_V_drop() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_drop();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")
    public void g_V_outE_drop() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_outE_drop();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")
    public void g_V_properties_drop() {
        Traversal<Vertex, VertexProperty> traversal = this.get_g_V_properties_drop();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        this.g.V(new Object[0]).forEachRemaining(vertex -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[0]))));
    }

    public static class Traversals
    extends DropTest {
        @Override
        public Traversal<Vertex, Vertex> get_g_V_drop() {
            return this.g.V(new Object[0]).drop();
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_outE_drop() {
            return this.g.V(new Object[0]).outE(new String[0]).drop();
        }

        @Override
        public Traversal<Vertex, VertexProperty> get_g_V_properties_drop() {
            return this.g.V(new Object[0]).properties(new String[0]).drop();
        }
    }
}

