/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.util;

public class QName {
    private final String qualifier;
    private final String localName;

    public QName(String localName) {
        this(null, localName);
    }

    public QName(String qualifier, String localName) {
        this.localName = localName;
        this.qualifier = qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getLocalName() {
        return this.localName;
    }

    public static QName parseQName(String identifier) {
        String localName;
        String qualifier;
        String[] split = identifier.split(":", 2);
        if (split.length == 2) {
            qualifier = split[0];
            localName = split[1];
        } else {
            qualifier = null;
            localName = split[0];
        }
        return new QName(qualifier, localName);
    }

    public String toString() {
        return QName.combine(this.qualifier, this.localName);
    }

    public static String combine(String qualifier, String localName) {
        if (qualifier == null || qualifier.isEmpty()) {
            return localName;
        }
        return qualifier + ":" + localName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = prime * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QName other = (QName)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }
}

