/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.db;

import java.util.List;
import org.camunda.bpm.cockpit.db.CommandExecutor;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.impl.db.QuerySessionFactory;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.QueryMaxResultsLimitUtil;

public class QueryServiceImpl
implements QueryService {
    private CommandExecutor commandExecutor;

    public QueryServiceImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <T> List<T> executeQuery(String statement, QueryParameters<T> parameter) {
        return (List)this.commandExecutor.executeCommand(commandContext -> {
            ProcessEngineConfigurationImpl engineConfig = this.getProcessEngineConfiguration(commandContext);
            this.configureAuthCheck(parameter, engineConfig, commandContext);
            if (parameter.isMaxResultsLimitEnabled()) {
                QueryMaxResultsLimitUtil.checkMaxResultsLimit((int)parameter.getMaxResults(), (ProcessEngineConfigurationImpl)engineConfig);
            }
            return commandContext.getDbSqlSession().selectList(statement, (Object)parameter);
        });
    }

    @Override
    public <T> T executeQuery(String statement, Object parameter, Class<T> clazz) {
        return this.commandExecutor.executeCommand(commandContext -> commandContext.getDbSqlSession().selectOne(statement, parameter));
    }

    @Override
    public Long executeQueryRowCount(String statement, ListQueryParameterObject parameter) {
        return (Long)this.commandExecutor.executeCommand(commandContext -> {
            ProcessEngineConfigurationImpl engineConfig = this.getProcessEngineConfiguration(commandContext);
            this.configureAuthCheck(parameter, engineConfig, commandContext);
            return (Long)commandContext.getDbSqlSession().selectOne(statement, (Object)parameter);
        });
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration(CommandContext commandContext) {
        QuerySessionFactory querySessionFactory = (QuerySessionFactory)commandContext.getProcessEngineConfiguration();
        ProcessEngineConfigurationImpl processEngineConfiguration = null;
        if (querySessionFactory != null) {
            processEngineConfiguration = querySessionFactory.getWrappedConfiguration();
        }
        if (processEngineConfiguration == null) {
            throw new ProcessEngineException("Process Engine Configuration missing!");
        }
        return processEngineConfiguration;
    }

    protected <T> void configureAuthCheck(ListQueryParameterObject parameter, ProcessEngineConfigurationImpl engineConfig, CommandContext commandContext) {
        AuthorizationCheck authCheck = parameter.getAuthCheck();
        commandContext.getAuthorizationManager().enableQueryAuthCheck(authCheck);
        boolean isEnableHistoricInstancePermissions = engineConfig.isEnableHistoricInstancePermissions();
        authCheck.setHistoricInstancePermissionsEnabled(isEnableHistoricInstancePermissions);
    }
}

