/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class EnumLiteral
extends EnumExpression
implements SQLLiteral {
    private final Enum value;

    public EnumLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Enum) {
            this.value = (Enum)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.delegate = mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING) ? new StringLiteral(stmt, mapping, (Object)(this.value != null ? this.value.name() : null), parameterName) : new IntegerLiteral(stmt, mapping, this.value != null ? Integer.valueOf(this.value.ordinal()) : null, parameterName);
    }

    @Override
    public void setJavaTypeMapping(JavaTypeMapping mapping) {
        super.setJavaTypeMapping(mapping);
        this.delegate = mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING) ? new StringLiteral(this.stmt, mapping, (Object)(this.value != null ? this.value.name() : null), this.parameterName) : new IntegerLiteral(this.stmt, mapping, this.value != null ? Integer.valueOf(this.value.ordinal()) : null, this.parameterName);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isParameter() {
        return this.delegate.isParameter();
    }

    @Override
    public void setNotParameter() {
        ((SQLLiteral)((Object)this.delegate)).setNotParameter();
    }
}

