/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.controller;

import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.dto.ApiResult;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.FlowDto;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.ui.dto.HandlerFeedBackDto;
import org.dromara.warm.flow.ui.dto.HandlerQuery;
import org.dromara.warm.flow.ui.service.WarmFlowService;
import org.dromara.warm.flow.ui.vo.Dict;
import org.dromara.warm.flow.ui.vo.HandlerFeedBackVo;
import org.dromara.warm.flow.ui.vo.HandlerSelectVo;
import org.dromara.warm.flow.ui.vo.NodeExt;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warm-flow"})
public class WarmFlowController {
    @PostMapping(value={"/save-json"})
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> saveJson(@RequestBody DefJson defJson) throws Exception {
        return WarmFlowService.saveJson((DefJson)defJson);
    }

    @GetMapping(value={"/query-def/{id}"})
    public ApiResult<DefJson> queryDef(@PathVariable(value="id") Long id) {
        return WarmFlowService.queryDef((Long)id);
    }

    @GetMapping(value={"/query-flow-chart/{id}"})
    public ApiResult<DefJson> queryFlowChart(@PathVariable(value="id") Long id) {
        return WarmFlowService.queryFlowChart((Long)id);
    }

    @GetMapping(value={"/handler-type"})
    public ApiResult<List<String>> handlerType() {
        return WarmFlowService.handlerType();
    }

    @GetMapping(value={"/handler-result"})
    public ApiResult<HandlerSelectVo> handlerResult(HandlerQuery query) {
        return WarmFlowService.handlerResult((HandlerQuery)query);
    }

    @GetMapping(value={"/handler-feedback"})
    public ApiResult<List<HandlerFeedBackVo>> handlerFeedback(HandlerFeedBackDto handlerFeedBackDto) {
        return WarmFlowService.handlerFeedback((HandlerFeedBackDto)handlerFeedBackDto);
    }

    @GetMapping(value={"/handler-dict"})
    public ApiResult<List<Dict>> handlerDict() {
        return WarmFlowService.handlerDict();
    }

    @Transactional(rollbackFor={Exception.class})
    @GetMapping(value={"/published-form"})
    public ApiResult<List<Form>> publishedForm() {
        return WarmFlowService.publishedForm();
    }

    @GetMapping(value={"/form-content/{id}"})
    public ApiResult<String> getFormContent(@PathVariable(value="id") Long id) {
        return WarmFlowService.getFormContent((Long)id);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/form-content"})
    public ApiResult<Void> saveFormContent(@RequestBody FlowDto flowDto) {
        return WarmFlowService.saveFormContent((FlowDto)flowDto);
    }

    @GetMapping(value={"/execute/load/{taskId}"})
    public ApiResult<FlowDto> load(@PathVariable(value="taskId") Long taskId) {
        return WarmFlowService.load((Long)taskId);
    }

    @GetMapping(value={"/execute/hisLoad/{taskId}"})
    public ApiResult<FlowDto> hisLoad(@PathVariable(value="taskId") Long hisTaskId) {
        return WarmFlowService.hisLoad((Long)hisTaskId);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/execute/handle"})
    public ApiResult<Instance> handle(@RequestBody Map<String, Object> formData, @RequestParam(value="taskId") Long taskId, @RequestParam(value="skipType") String skipType, @RequestParam(value="message") String message, @RequestParam(value="nodeCode", required=false) String nodeCode) {
        return WarmFlowService.handle(formData, (Long)taskId, (String)skipType, (String)message, (String)nodeCode);
    }

    @GetMapping(value={"/node-ext"})
    public ApiResult<List<NodeExt>> nodeExt() {
        return WarmFlowService.nodeExt();
    }
}

