/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangeCaseInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public abstract class AbstractDeleteCaseInstanceOperation
extends AbstractChangeCaseInstanceStateOperation {
    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, String caseInstanceId) {
        super(commandContext, caseInstanceId);
    }

    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, CaseInstanceEntity caseInstanceEntity) {
        super(commandContext, caseInstanceEntity);
    }

    @Override
    public void run() {
        super.run();
        this.deleteCaseInstance();
    }

    protected void deleteCaseInstance() {
        this.updateChildPlanItemInstancesState();
        CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).delete(this.caseInstanceEntity.getId(), false, this.getDeleteReason());
        String newState = this.getNewState();
        CommandContextUtil.getCaseInstanceHelper(this.commandContext).callCaseInstanceStateChangeCallbacks(this.commandContext, this.caseInstanceEntity, this.caseInstanceEntity.getState(), newState);
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordCaseInstanceEnd(this.caseInstanceEntityId, newState);
    }

    protected void updateChildPlanItemInstancesState() {
        List childPlanItemInstances = this.caseInstanceEntity.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (!"active".equals(childPlanItemInstance.getState()) && !"available".equals(childPlanItemInstance.getState())) continue;
                this.changeStateForChildPlanItemInstance(childPlanItemInstance);
            }
        }
    }

    protected abstract String getDeleteReason();
}

