/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public abstract class AbstractDeletePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public AbstractDeletePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        super.run();
        boolean isRepeating = this.isRepeatingOnDelete();
        if (isRepeating) {
            PlanItemInstanceEntity newPlanItemInstanceEntity = this.createNewPlanItemInstance();
            CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(newPlanItemInstanceEntity);
            int counter = this.getRepetitionCounter(this.planItemInstanceEntity);
            this.setRepetitionCounter(newPlanItemInstanceEntity, ++counter);
            CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(newPlanItemInstanceEntity);
        }
        this.deleteSentryPartInstances();
        CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext).delete(this.planItemInstanceEntity);
    }

    protected PlanItemInstanceEntity createNewPlanItemInstance() {
        return this.copyAndInsertPlanItemInstance(this.commandContext, this.planItemInstanceEntity);
    }

    protected boolean isRepeatingOnDelete() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        if (this.isEvaluateRepetitionRule() && this.isPlanItemRepeatableOnComplete(planItem)) {
            return this.evaluateRepetitionRule(this.planItemInstanceEntity);
        }
        return false;
    }

    protected void exitChildPlanItemInstances() {
        for (PlanItemInstanceEntity child : this.planItemInstanceEntity.getChildPlanItemInstances()) {
            if (!StateTransition.isPossible((PlanItemInstance)child, "exit")) continue;
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(child);
        }
    }

    protected abstract boolean isEvaluateRepetitionRule();
}

