/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Collection;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class RemoveLocalVariablesCmd
implements Command<Void> {
    protected String planItemInstanceId;
    protected Collection<String> variableNames;

    public RemoveLocalVariablesCmd(String planItemInstanceId, Collection<String> variableNames) {
        this.planItemInstanceId = planItemInstanceId;
        this.variableNames = variableNames;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("planItemInstanceId is null");
        }
        if (this.variableNames == null) {
            throw new FlowableIllegalArgumentException("variableNames is null");
        }
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No plan item instance found for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        planItemInstanceEntity.removeVariables(this.variableNames);
        return null;
    }
}

