/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.deploy.CaseDefinitionCacheEntry;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.persistence.deploy.DeploymentCache;

public class SetCaseDefinitionCategoryCmd
implements Command<Void> {
    protected String caseDefinitionId;
    protected String category;

    public SetCaseDefinitionCategoryCmd(String caseDefinitionId, String category) {
        this.caseDefinitionId = caseDefinitionId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)CommandContextUtil.getCaseDefinitionEntityManager(commandContext).findById(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("No case definition found for id = '" + this.caseDefinitionId + "'", CaseDefinition.class);
        }
        caseDefinition.setCategory(this.category);
        DeploymentCache<CaseDefinitionCacheEntry> caseDefinitionCache = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCaseDefinitionCache();
        if (caseDefinitionCache != null) {
            caseDefinitionCache.remove(this.caseDefinitionId);
        }
        return null;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

