/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CaseDefinitionDiagramHelper;
import org.flowable.cmmn.engine.impl.deployer.ResourceNameUtil;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.deploy.CaseDefinitionCacheEntry;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.repository.EngineDeployment;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.common.impl.EngineDeployer;
import org.flowable.engine.common.impl.cfg.IdGenerator;
import org.flowable.engine.common.impl.persistence.deploy.DeploymentCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDeployer.class);
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{".cmmn", ".cmmn11", ".cmmn.xml", ".cmmn11.xml"};
    protected IdGenerator idGenerator;
    protected CmmnParser cmmnParser;
    protected CaseDefinitionDiagramHelper caseDefinitionDiagramHelper;

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        CmmnParseResult parseResult = new CmmnParseResult(deployment);
        for (EngineResource resource : deployment.getResources().values()) {
            if (!CmmnDeployer.isCmmnResource(resource.getName())) continue;
            LOGGER.debug("Processing CMMN resource {}", (Object)resource.getName());
            parseResult.merge(this.cmmnParser.parse(resource));
        }
        this.verifyCaseDefinitionsDoNotShareKeys(parseResult.getAllCaseDefinitions());
        this.copyDeploymentValuesToCaseDefinitions(parseResult.getDeployment(), parseResult.getAllCaseDefinitions());
        this.setResourceNamesOnCaseDefinitions(parseResult);
        this.createAndPersistNewDiagramsIfNeeded(parseResult);
        this.setCaseDefinitionDiagramNames(parseResult);
        if (deployment.isNew()) {
            Map<CaseDefinitionEntity, CaseDefinitionEntity> mapOfNewCaseDefinitionToPreviousVersion = this.getPreviousVersionsOfCaseDefinitions(parseResult);
            this.setCaseDefinitionVersionsAndIds(parseResult, mapOfNewCaseDefinitionToPreviousVersion);
            this.persistCaseDefinitions(parseResult);
        } else {
            this.makeCaseDefinitionsConsistentWithPersistedVersions(parseResult);
        }
        this.updateCachingAndArtifacts(parseResult);
    }

    public static boolean isCmmnResource(String resourceName) {
        for (String suffix : CMMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected void createAndPersistNewDiagramsIfNeeded(CmmnParseResult parseResult) {
        for (CaseDefinitionEntity caseDefinition : parseResult.getAllCaseDefinitions()) {
            CmmnResourceEntity resource;
            if (!this.caseDefinitionDiagramHelper.shouldCreateDiagram(caseDefinition, parseResult.getDeployment()) || (resource = this.caseDefinitionDiagramHelper.createDiagramForCaseDefinition(caseDefinition, parseResult.getCmmnModelForCaseDefinition(caseDefinition))) == null) continue;
            CommandContextUtil.getCmmnResourceEntityManager().insert(resource, false);
            ((CmmnDeploymentEntity)parseResult.getDeployment()).addResource(resource);
        }
    }

    protected void setCaseDefinitionDiagramNames(CmmnParseResult parseResult) {
        Map resources = parseResult.getDeployment().getResources();
        for (CaseDefinitionEntity caseDefinition : parseResult.getAllCaseDefinitions()) {
            String diagramResourceName = ResourceNameUtil.getCaseDiagramResourceNameFromDeployment(caseDefinition, resources);
            caseDefinition.setDiagramResourceName(diagramResourceName);
        }
    }

    protected Map<CaseDefinitionEntity, CaseDefinitionEntity> getPreviousVersionsOfCaseDefinitions(CmmnParseResult parseResult) {
        LinkedHashMap<CaseDefinitionEntity, CaseDefinitionEntity> result = new LinkedHashMap<CaseDefinitionEntity, CaseDefinitionEntity>();
        for (CaseDefinitionEntity newDefinition : parseResult.getAllCaseDefinitions()) {
            CaseDefinitionEntity existingDefinition = this.getMostRecentVersionOfCaseDefinition(newDefinition);
            if (existingDefinition == null) continue;
            result.put(newDefinition, existingDefinition);
        }
        return result;
    }

    protected void setCaseDefinitionVersionsAndIds(CmmnParseResult parseResult, Map<CaseDefinitionEntity, CaseDefinitionEntity> mapNewToOldCaseDefinitions) {
        for (CaseDefinitionEntity caseDefinition : parseResult.getAllCaseDefinitions()) {
            int version = 1;
            CaseDefinitionEntity latest = mapNewToOldCaseDefinitions.get(caseDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            caseDefinition.setVersion(version);
            caseDefinition.setId(this.idGenerator.getNextId());
            Case caseObject = parseResult.getCmmnCaseForCaseDefinition(caseDefinition);
            if (caseObject.getPlanModel().getFormKey() == null) continue;
            caseDefinition.setHasStartFormKey(true);
        }
    }

    protected void persistCaseDefinitions(CmmnParseResult parseResult) {
        CaseDefinitionEntityManager caseDefinitionManager = CommandContextUtil.getCaseDefinitionEntityManager();
        for (CaseDefinitionEntity caseDefinition : parseResult.getAllCaseDefinitions()) {
            caseDefinitionManager.insert(caseDefinition, false);
        }
    }

    protected void makeCaseDefinitionsConsistentWithPersistedVersions(CmmnParseResult parseResult) {
        for (CaseDefinitionEntity caseDefinition : parseResult.getAllCaseDefinitions()) {
            CaseDefinitionEntity persistedCaseDefinition = this.getPersistedInstanceOfCaseDefinition(caseDefinition);
            if (persistedCaseDefinition == null) continue;
            caseDefinition.setId(persistedCaseDefinition.getId());
            caseDefinition.setVersion(persistedCaseDefinition.getVersion());
            caseDefinition.setHasStartFormKey(persistedCaseDefinition.hasStartFormKey());
            caseDefinition.setHasGraphicalNotation(persistedCaseDefinition.hasGraphicalNotation());
        }
    }

    protected void verifyCaseDefinitionsDoNotShareKeys(Collection<CaseDefinitionEntity> caseDefinitionEntities) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (CaseDefinitionEntity caseDefinitionEntity : caseDefinitionEntities) {
            if (keySet.contains(caseDefinitionEntity.getKey())) {
                throw new FlowableException("The deployment contains case definitions with the same key (case id attribute), this is not allowed");
            }
            keySet.add(caseDefinitionEntity.getKey());
        }
    }

    protected void copyDeploymentValuesToCaseDefinitions(EngineDeployment deployment, List<CaseDefinitionEntity> caseDefinitionEntities) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (CaseDefinitionEntity caseDefinitionEntity : caseDefinitionEntities) {
            if (tenantId != null) {
                caseDefinitionEntity.setTenantId(tenantId);
            }
            caseDefinitionEntity.setDeploymentId(deploymentId);
        }
    }

    protected void setResourceNamesOnCaseDefinitions(CmmnParseResult parseResult) {
        for (CaseDefinitionEntity caseDefinitionEntity : parseResult.getAllCaseDefinitions()) {
            String resourceName = parseResult.getResourceForCaseDefinition(caseDefinitionEntity).getName();
            caseDefinitionEntity.setResourceName(resourceName);
        }
    }

    protected CaseDefinitionEntity getMostRecentVersionOfCaseDefinition(CaseDefinitionEntity caseDefinitionEntity) {
        String key = caseDefinitionEntity.getKey();
        String tenantId = caseDefinitionEntity.getTenantId();
        CaseDefinitionEntityManager caseDefinitionEntityManager = CommandContextUtil.getCaseDefinitionEntityManager();
        CaseDefinitionEntity existingCaseDefinition = null;
        existingCaseDefinition = tenantId != null && !tenantId.equals("") ? caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(key, tenantId) : caseDefinitionEntityManager.findLatestCaseDefinitionByKey(key);
        return existingCaseDefinition;
    }

    protected CaseDefinitionEntity getPersistedInstanceOfCaseDefinition(CaseDefinitionEntity caseDefinitionEntity) {
        String deploymentId = caseDefinitionEntity.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)caseDefinitionEntity.getDeploymentId())) {
            throw new IllegalStateException("Provided case definition must have a deployment id.");
        }
        CaseDefinitionEntityManager caseDefinitionEntityManager = CommandContextUtil.getCaseDefinitionEntityManager();
        CaseDefinitionEntity persistedCaseDefinitionEntity = null;
        persistedCaseDefinitionEntity = caseDefinitionEntity.getTenantId() == null || "".equals(caseDefinitionEntity.getTenantId()) ? caseDefinitionEntityManager.findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionEntity.getKey()) : caseDefinitionEntityManager.findCaseDefinitionByDeploymentAndKeyAndTenantId(deploymentId, caseDefinitionEntity.getKey(), caseDefinitionEntity.getTenantId());
        return persistedCaseDefinitionEntity;
    }

    protected void updateCachingAndArtifacts(CmmnParseResult parseResult) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        DeploymentCache<CaseDefinitionCacheEntry> caseDefinitionCache = cmmnEngineConfiguration.getCaseDefinitionCache();
        CmmnDeploymentEntity deployment = (CmmnDeploymentEntity)parseResult.getDeployment();
        for (CaseDefinitionEntity caseDefinitionEntity : parseResult.getAllCaseDefinitions()) {
            CmmnModel model = parseResult.getCmmnModelForCaseDefinition(caseDefinitionEntity);
            Case caze = parseResult.getCmmnCaseForCaseDefinition(caseDefinitionEntity);
            CaseDefinitionCacheEntry cacheEntry = new CaseDefinitionCacheEntry(caseDefinitionEntity, model, caze);
            caseDefinitionCache.add(caseDefinitionEntity.getId(), (Object)cacheEntry);
            deployment.addDeployedArtifact(caseDefinitionEntity);
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public CmmnParser getCmmnParser() {
        return this.cmmnParser;
    }

    public void setCmmnParser(CmmnParser cmmnParser) {
        this.cmmnParser = cmmnParser;
    }

    public CaseDefinitionDiagramHelper getCaseDefinitionDiagramHelper() {
        return this.caseDefinitionDiagramHelper;
    }

    public void setCaseDefinitionDiagramHelper(CaseDefinitionDiagramHelper caseDefinitionDiagramHelper) {
        this.caseDefinitionDiagramHelper = caseDefinitionDiagramHelper;
    }
}

