/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring.configurator;

import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.configurator.CmmnEngineConfigurator;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.cmmn.spring.SpringCmmnExpressionManager;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringCmmnEngineConfigurator
extends CmmnEngineConfigurator {
    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.cmmnEngineConfiguration == null) {
            this.cmmnEngineConfiguration = new SpringCmmnEngineConfiguration();
        }
        if (!(this.cmmnEngineConfiguration instanceof SpringCmmnEngineConfiguration)) {
            throw new FlowableException("SpringCmmnEngineConfigurator accepts only SpringCmmnEngineConfiguration. " + this.cmmnEngineConfiguration.getClass().getName());
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
        SpringProcessEngineConfiguration springProcessEngineConfiguration = (SpringProcessEngineConfiguration)engineConfiguration;
        this.initProcessInstanceService((ProcessEngineConfigurationImpl)springProcessEngineConfiguration);
        this.initProcessInstanceStateChangedCallbacks((ProcessEngineConfigurationImpl)springProcessEngineConfiguration);
        this.cmmnEngineConfiguration.setEnableTaskRelationshipCounts(springProcessEngineConfiguration.getPerformanceSettings().isEnableTaskRelationshipCounts());
        this.cmmnEngineConfiguration.setTaskQueryLimit(springProcessEngineConfiguration.getTaskQueryLimit());
        this.cmmnEngineConfiguration.setHistoricTaskQueryLimit(springProcessEngineConfiguration.getHistoricTaskQueryLimit());
        ((SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration).setTransactionManager(springProcessEngineConfiguration.getTransactionManager());
        this.cmmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringCmmnExpressionManager(springProcessEngineConfiguration.getApplicationContext(), springProcessEngineConfiguration.getBeans()));
        this.initCmmnEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
    }

    protected synchronized CmmnEngine initCmmnEngine() {
        if (this.cmmnEngineConfiguration == null) {
            throw new FlowableException("CmmnEngineConfiguration is required");
        }
        return this.cmmnEngineConfiguration.buildCmmnEngine();
    }

    public SpringCmmnEngineConfiguration getCmmnEngineConfiguration() {
        return (SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration;
    }

    public SpringCmmnEngineConfigurator setCmmnEngineConfiguration(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        return this;
    }
}

