/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.history.HistoryLevel;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.saveTask(this.task);
            return null;
        }
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        if (this.task.getRevision() == 0) {
            TaskHelper.insertTask(this.task, null, true);
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)this.task));
            }
            this.handleSubTaskCount(taskService, null);
        } else {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            TaskEntity originalTaskEntity = taskService.getTask(this.task.getId());
            if (originalTaskEntity == null && processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.task.getId());
            }
            CommandContextUtil.getHistoryManager(commandContext).recordTaskInfoChange(this.task);
            taskService.updateTask(this.task, true);
            if (!StringUtils.equals((CharSequence)originalTaskEntity.getAssignee(), (CharSequence)this.task.getAssignee())) {
                this.handleAssigneeChange(commandContext, processEngineConfiguration);
            }
            if (!StringUtils.equals((CharSequence)originalTaskEntity.getParentTaskId(), (CharSequence)this.task.getParentTaskId())) {
                this.handleSubTaskCount(taskService, (TaskInfo)originalTaskEntity);
            }
        }
        return null;
    }

    protected void handleAssigneeChange(CommandContext commandContext, ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_ASSIGNED, (Object)this.task));
        }
    }

    protected void handleSubTaskCount(TaskService taskService, TaskInfo originalTaskEntity) {
        if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(this.task)) {
            if (this.task.getParentTaskId() != null && (originalTaskEntity == null || originalTaskEntity.getParentTaskId() == null)) {
                TaskEntity parentTaskEntity = taskService.getTask(this.task.getParentTaskId());
                if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(parentTaskEntity)) {
                    CountingTaskEntity countingParentTaskEntity = (CountingTaskEntity)parentTaskEntity;
                    countingParentTaskEntity.setSubTaskCount(countingParentTaskEntity.getSubTaskCount() + 1);
                    parentTaskEntity.forceUpdate();
                }
            } else if (this.task.getParentTaskId() == null && originalTaskEntity != null && originalTaskEntity.getParentTaskId() != null) {
                TaskEntity parentTaskEntity = taskService.getTask(originalTaskEntity.getParentTaskId());
                if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(parentTaskEntity)) {
                    CountingTaskEntity countingParentTaskEntity = (CountingTaskEntity)parentTaskEntity;
                    countingParentTaskEntity.setSubTaskCount(countingParentTaskEntity.getSubTaskCount() - 1);
                    parentTaskEntity.forceUpdate();
                }
            } else if (this.task.getParentTaskId() != null && originalTaskEntity.getParentTaskId() != null && !this.task.getParentTaskId().equals(originalTaskEntity.getParentTaskId())) {
                TaskEntity parentTaskEntity;
                TaskEntity originalParentTaskEntity = taskService.getTask(originalTaskEntity.getParentTaskId());
                if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(originalParentTaskEntity)) {
                    CountingTaskEntity countingOriginalParentTaskEntity = (CountingTaskEntity)originalParentTaskEntity;
                    countingOriginalParentTaskEntity.setSubTaskCount(countingOriginalParentTaskEntity.getSubTaskCount() - 1);
                    originalParentTaskEntity.forceUpdate();
                }
                if (CountingEntityUtil.isTaskRelatedEntityCountEnabled(parentTaskEntity = taskService.getTask(this.task.getParentTaskId()))) {
                    CountingTaskEntity countingParentTaskEntity = (CountingTaskEntity)parentTaskEntity;
                    countingParentTaskEntity.setSubTaskCount(countingParentTaskEntity.getSubTaskCount() + 1);
                    parentTaskEntity.forceUpdate();
                }
            }
        }
    }
}

