/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class SubProcessInstanceStartHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "subprocess-instance-start";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        String activityId = this.getStringFromJson(historicalData, "activityId");
        HistoricActivityInstanceEntity activityInstance = this.findHistoricActivityInstance(commandContext, this.getStringFromJson(historicalData, "executionId"), activityId);
        return activityInstance != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId;
        HistoricActivityInstanceEntity activityInstance;
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext);
        String id = this.getStringFromJson(historicalData, "id");
        String processInstanceId = this.getStringFromJson(historicalData, "processInstanceId");
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(id);
        if (historicProcessInstance == null) {
            HistoricProcessInstanceEntity subProcessInstance = historicProcessInstanceEntityManager.create();
            subProcessInstance.setId(id);
            subProcessInstance.setProcessInstanceId(processInstanceId);
            subProcessInstance.setBusinessKey(this.getStringFromJson(historicalData, "businessKey"));
            subProcessInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
            subProcessInstance.setProcessDefinitionKey(this.getStringFromJson(historicalData, "processDefinitionKey"));
            subProcessInstance.setProcessDefinitionName(this.getStringFromJson(historicalData, "processDefinitionName"));
            String versionString = this.getStringFromJson(historicalData, "processDefinitionVersion");
            subProcessInstance.setProcessDefinitionVersion(versionString != null ? Integer.valueOf(versionString) : 0);
            subProcessInstance.setDeploymentId(this.getStringFromJson(historicalData, "deploymentId"));
            subProcessInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
            subProcessInstance.setStartUserId(this.getStringFromJson(historicalData, "startUserId"));
            subProcessInstance.setStartActivityId(this.getStringFromJson(historicalData, "startActivityId"));
            subProcessInstance.setSuperProcessInstanceId(this.getStringFromJson(historicalData, "superProcessInstanceId"));
            subProcessInstance.setCallbackId(this.getStringFromJson(historicalData, "callbackId"));
            subProcessInstance.setCallbackType(this.getStringFromJson(historicalData, "callbackType"));
            subProcessInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            historicProcessInstanceEntityManager.insert(subProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, subProcessInstance));
        }
        if ((activityInstance = this.findHistoricActivityInstance(commandContext, executionId = this.getStringFromJson(historicalData, "executionId"), activityId = this.getStringFromJson(historicalData, "activityId"))) != null) {
            activityInstance.setCalledProcessInstanceId(processInstanceId);
        }
    }
}

