/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import java.util.Arrays;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.scripting.Resolver;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class VariableScopeResolver
implements Resolver {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected VariableScope variableScope;
    protected String variableScopeKey = "execution";
    protected static final String processEngineConfigurationKey = "processEngineConfiguration";
    protected static final String runtimeServiceKey = "runtimeService";
    protected static final String taskServiceKey = "taskService";
    protected static final String repositoryServiceKey = "repositoryService";
    protected static final String managementServiceKey = "managementService";
    protected static final String historyServiceKey = "historyService";
    protected static final String formServiceKey = "formService";
    protected static final String identityServiceKey = "identityServiceKey";
    protected static final List<String> KEYS = Arrays.asList("processEngineConfiguration", "runtimeService", "taskService", "repositoryService", "managementService", "historyService", "formService", "identityServiceKey");

    public VariableScopeResolver(ProcessEngineConfigurationImpl processEngineConfiguration, VariableScope variableScope) {
        this.processEngineConfiguration = processEngineConfiguration;
        if (variableScope == null) {
            throw new FlowableIllegalArgumentException("variableScope cannot be null");
        }
        if (variableScope instanceof ExecutionEntity) {
            this.variableScopeKey = "execution";
        } else if (variableScope instanceof TaskEntity) {
            this.variableScopeKey = "task";
        } else {
            throw new FlowableException("unsupported variable scope type: " + variableScope.getClass().getName());
        }
        this.variableScope = variableScope;
    }

    public boolean containsKey(Object key) {
        return this.variableScopeKey.equals(key) || KEYS.contains(key) || this.variableScope.hasVariable((String)key);
    }

    public Object get(Object key) {
        if (this.variableScopeKey.equals(key)) {
            return this.variableScope;
        }
        if (processEngineConfigurationKey.equals(key)) {
            return this.processEngineConfiguration;
        }
        if (runtimeServiceKey.equals(key)) {
            return this.processEngineConfiguration.getRuntimeService();
        }
        if (taskServiceKey.equals(key)) {
            return this.processEngineConfiguration.getTaskService();
        }
        if (repositoryServiceKey.equals(key)) {
            return this.processEngineConfiguration.getRepositoryService();
        }
        if (managementServiceKey.equals(key)) {
            return this.processEngineConfiguration.getManagementService();
        }
        if (formServiceKey.equals(key)) {
            return this.processEngineConfiguration.getFormService();
        }
        if (identityServiceKey.equals(key)) {
            return this.processEngineConfiguration.getIdentityService();
        }
        return this.variableScope.getVariable((String)key);
    }
}

