/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntity;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntityManager;
import org.flowable.form.engine.impl.persistence.entity.data.FormDeploymentDataManager;

public class FormDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<FormEngineConfiguration, FormDeploymentEntity, FormDeploymentDataManager>
implements FormDeploymentEntityManager {
    public FormDeploymentEntityManagerImpl(FormEngineConfiguration formEngineConfiguration, FormDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)formEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(FormDeploymentEntity deployment) {
        this.insert(deployment, true);
    }

    public void insert(FormDeploymentEntity deployment, boolean fireEvent) {
        super.insert((Entity)deployment, fireEvent);
        for (FormResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.deleteFormDefinitionsForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected void deleteFormDefinitionsForDeployment(String deploymentId) {
        this.getFormDefinitionEntityManager().deleteFormDefinitionsByDeploymentId(deploymentId);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(FormDeploymentQueryImpl deploymentQuery) {
        return ((FormDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<FormDeployment> findDeploymentsByQueryCriteria(FormDeploymentQueryImpl deploymentQuery) {
        return ((FormDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((FormDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<FormDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((FormDeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((FormDeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected FormResourceEntityManager getResourceEntityManager() {
        return ((FormEngineConfiguration)this.engineConfiguration).getResourceEntityManager();
    }

    protected FormDefinitionEntityManager getFormDefinitionEntityManager() {
        return ((FormEngineConfiguration)this.engineConfiguration).getFormDefinitionEntityManager();
    }
}

