/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class ResourceParentFolderAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "resource-parent-folder";
    private static final String DEPLOYMENT_NAME_PATTERN = "%s.%s";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, FormRepositoryService repositoryService) {
        Map<String, Set<Resource>> resourcesMap = this.createMap(resources);
        for (Map.Entry<String, Set<Resource>> group : resourcesMap.entrySet()) {
            String deploymentName = this.determineDeploymentName(deploymentNameHint, group.getKey());
            FormDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentName);
            for (Resource resource : group.getValue()) {
                String resourceName = this.determineResourceName(resource);
                try {
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
                catch (IOException e) {
                    throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
                }
            }
            deploymentBuilder.deploy();
        }
    }

    private Map<String, Set<Resource>> createMap(Resource[] resources) {
        HashMap<String, Set<Resource>> resourcesMap = new HashMap<String, Set<Resource>>();
        for (Resource resource : resources) {
            String parentFolderName = this.determineGroupName(resource);
            if (resourcesMap.get(parentFolderName) == null) {
                resourcesMap.put(parentFolderName, new HashSet());
            }
            ((Set)resourcesMap.get(parentFolderName)).add(resource);
        }
        return resourcesMap;
    }

    private String determineGroupName(Resource resource) {
        String result = this.determineResourceName(resource);
        try {
            if (this.resourceParentIsDirectory(resource)) {
                result = resource.getFile().getParentFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private boolean resourceParentIsDirectory(Resource resource) throws IOException {
        return resource.getFile() != null && resource.getFile().getParentFile() != null && resource.getFile().getParentFile().isDirectory();
    }

    private String determineDeploymentName(String deploymentNameHint, String groupName) {
        return String.format(DEPLOYMENT_NAME_PATTERN, deploymentNameHint, groupName);
    }
}

