/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize.java8;

import hprose.io.convert.java8.LocalTimeConverter;
import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalTime;

public final class LocalTimeUnserializer
extends BaseUnserializer<LocalTime> {
    public static final LocalTimeUnserializer instance = new LocalTimeUnserializer();

    @Override
    public LocalTime unserialize(Reader reader, int tag, Type type) throws IOException {
        LocalTimeConverter converter = LocalTimeConverter.instance;
        switch (tag) {
            case 68: {
                return converter.convertTo(ReferenceReader.readDateTime(reader));
            }
            case 84: {
                return converter.convertTo(ReferenceReader.readTime(reader));
            }
            case 101: {
                return null;
            }
            case 115: {
                return converter.convertTo(ReferenceReader.readString(reader));
            }
            case 105: 
            case 108: {
                return converter.convertTo(ValueReader.readLong(reader));
            }
            case 100: {
                return converter.convertTo(ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return converter.convertTo(tag - 48);
        }
        return (LocalTime)super.unserialize(reader, tag, type);
    }

    public LocalTime read(Reader reader) throws IOException {
        return (LocalTime)this.read(reader, (Type)((Object)LocalTime.class));
    }
}

