/*
 * Decompiled with CFR 0.152.
 */
package hprose.util.concurrent;

import hprose.util.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Timer {
    private static volatile ScheduledExecutorService timer1 = Executors.newSingleThreadScheduledExecutor();
    private static volatile ScheduledExecutorService timer2 = Executors.newSingleThreadScheduledExecutor();
    private final Runnable timeoutCallback;
    private volatile Future<?> timeoutID = null;

    public Timer(Runnable callback) {
        this.timeoutCallback = callback;
    }

    public synchronized void clear() {
        if (this.timeoutID != null) {
            this.timeoutID.cancel(true);
            this.timeoutID = null;
        }
    }

    public synchronized void setTimeout(int timeout) {
        this.setTimeout(timeout, false);
    }

    public synchronized void setInterval(int timeout) {
        this.setInterval(timeout, false);
    }

    public synchronized void setTimeout(int timeout, boolean waitOnShutdown) {
        this.clear();
        this.timeoutID = (waitOnShutdown ? timer1 : timer2).schedule(this.timeoutCallback, (long)timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized void setInterval(int timeout, boolean waitOnShutdown) {
        this.clear();
        if (timeout > 0) {
            this.timeoutID = (waitOnShutdown ? timer1 : timer2).scheduleAtFixedRate(this.timeoutCallback, timeout, timeout, TimeUnit.MILLISECONDS);
        }
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            @Override
            public void run() {
                ScheduledExecutorService timer = timer1;
                timer1 = Executors.newSingleThreadScheduledExecutor();
                timer.shutdownNow();
                timer = timer2;
                timer2 = Executors.newSingleThreadScheduledExecutor();
                List<Runnable> tasks = timer.shutdownNow();
                for (Runnable task : tasks) {
                    task.run();
                }
            }
        });
    }
}

