/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

class StatementCache {
    private static StatementCache instance = new StatementCache();
    private HashMap<Connection, HashMap<String, PreparedStatement>> statementCache = new HashMap();

    private StatementCache() {
    }

    static StatementCache instance() {
        return instance;
    }

    PreparedStatement getPreparedStatement(Connection connection, String query) throws SQLException {
        if (!this.statementCache.containsKey(connection)) {
            this.statementCache.put(connection, new HashMap());
        }
        HashMap<String, PreparedStatement> preparedStatementMap = this.statementCache.get(connection);
        return preparedStatementMap.get(query);
    }

    public void cache(Connection connection, String query, PreparedStatement ps) {
        this.statementCache.get(connection).put(query, ps);
    }

    void cleanStatementCache(Connection connection) {
        this.statementCache.remove(connection);
    }
}

