/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.util.List;
import java.util.regex.Pattern;
import org.javalite.activejdbc.MetaModel;
import org.javalite.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDialect {
    protected final Pattern orderByPattern = Pattern.compile("^order *by", 10);
    protected final Pattern groupByPattern = Pattern.compile("^group *by", 10);

    public String selectStar(String table, String query) {
        return query != null ? "SELECT * FROM " + table + " WHERE " + query : "SELECT * FROM " + table;
    }

    public String selectStarParametrized(String table, String ... parameters) {
        String sql = "SELECT * FROM " + table + " WHERE ";
        for (String parameter : parameters) {
            sql = sql + parameter + " = ? AND ";
        }
        return sql.substring(0, sql.length() - 5);
    }

    public String createParametrizedInsert(MetaModel mm, List<String> nonNullAttributes) {
        String query = "INSERT INTO " + mm.getTableName() + " (" + Util.join(nonNullAttributes, (String)", ");
        query = query + (mm.getIdGeneratorCode() != null ? ", " + mm.getIdName() : "");
        query = query + (mm.isVersioned() ? ", record_version" : "");
        query = query + ") VALUES (" + this.getQuestions(nonNullAttributes.size());
        query = query + (mm.getIdGeneratorCode() != null ? ", " + mm.getIdGeneratorCode() : "");
        query = query + (mm.isVersioned() ? ", 1" : "");
        query = query + ")";
        return query;
    }

    public String createParametrizedInsertIdUnmanaged(MetaModel mm, List<String> nonNullAttributes) {
        String query = "INSERT INTO " + mm.getTableName() + " (" + Util.join(nonNullAttributes, (String)", ");
        query = query + (mm.isVersioned() ? ", record_version" : "");
        query = query + ") VALUES (" + this.getQuestions(nonNullAttributes.size());
        query = query + (mm.isVersioned() ? ", 1" : "");
        query = query + ")";
        return query;
    }

    private String getQuestions(int count) {
        String[] questions = new String[count];
        for (int i = 0; i < count; ++i) {
            questions[i] = "?";
        }
        return Util.join((String[])questions, (String)", ");
    }

    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        String fullQuery = "SELECT * FROM " + tableName;
        if (!Util.blank((Object)subQuery)) {
            String where = " WHERE ";
            if (!this.groupByPattern.matcher(subQuery.toLowerCase().trim()).find() && !this.orderByPattern.matcher(subQuery.toLowerCase().trim()).find()) {
                fullQuery = fullQuery + where;
            }
            fullQuery = fullQuery + " " + subQuery;
        }
        if (orderBys.size() != 0) {
            fullQuery = fullQuery + " ORDER BY " + Util.join(orderBys, (String)", ");
        }
        return fullQuery;
    }

    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        return value;
    }
}

