/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.javalite.activejdbc.Base;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveJdbcFilter
implements Filter {
    final Logger logger = LoggerFactory.getLogger(ActiveJdbcFilter.class);
    private static String jndiName;

    public void init(FilterConfig config) throws ServletException {
        jndiName = config.getInitParameter("jndiName");
        if (jndiName == null) {
            throw new IllegalArgumentException("must provide jndiName parameter for this filter");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        long before = System.currentTimeMillis();
        try {
            Base.open(jndiName);
            Base.openTransaction();
            chain.doFilter(req, resp);
            Base.commitTransaction();
        }
        catch (IOException e) {
            Base.rollbackTransaction();
            throw e;
        }
        catch (ServletException e) {
            Base.rollbackTransaction();
            throw e;
        }
        finally {
            Base.close();
        }
        this.logger.info("Processing took: " + (System.currentTimeMillis() - before) + " milliseconds");
    }

    public void destroy() {
    }
}

